/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.advice;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import whatap.agent.Logger;
import whatap.agent.conf.ConfInstrumentation;
import whatap.agent.conf.ConfTrace;
import whatap.agent.instrumentation.executor.ExecutorCallDepthMap;
import whatap.agent.instrumentation.executor.TaskClassFilter;
import whatap.agent.instrumentation.executor.advice.ExecutorContext;
import whatap.agent.instrumentation.executor.wrapper.ContextPropagatingCallable;
import whatap.agent.instrumentation.executor.wrapper.ContextPropagatingRunnable;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.util.KeyGen;

public class ExecutorAdvice {
    public static Runnable beforeExecute(Runnable task, Executor executor) {
        int depth = ExecutorCallDepthMap.forClass(executor.getClass()).getAndIncrement();
        try {
            if (depth > 0) {
                return task;
            }
            if (TaskClassFilter.shouldExclude(task)) {
                return task;
            }
            if (!ConfTrace.trace_executor_enabled) {
                return task;
            }
            TraceContext parentCtx = TraceContextManager.getLocalContext();
            if (parentCtx == null) {
                return task;
            }
            if (task instanceof ContextPropagatingRunnable) {
                return task;
            }
            String taskName = ExecutorAdvice.getTaskName(task);
            if (parentCtx.mtid == 0L) {
                parentCtx.mtid = KeyGen.next();
                parentCtx.mtid_build_checked = true;
            }
            ExecutorContext execCtx = new ExecutorContext(parentCtx);
            execCtx.taskName = taskName;
            execCtx.initChildTransaction(taskName);
            ContextPropagatingRunnable wrapped = new ContextPropagatingRunnable(task, execCtx);
            if (ConfInstrumentation.debug_instrumentation_executor_enabled) {
                Logger.println("Executor", "beforeExecute WRAPPED: task=" + taskName + ", parentTxid=" + parentCtx.txid + (execCtx.childContext != null ? ", childTxid=" + execCtx.childContext.txid : ""));
            }
            return wrapped;
        }
        catch (Throwable t) {
            Logger.println("Executor", 10, "beforeExecute ERROR: " + t);
            return task;
        }
    }

    public static void afterExecute(Executor executor) {
        try {
            ExecutorCallDepthMap.forClass(executor.getClass()).decrementAndGet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getTaskName(Runnable task) {
        if (task == null) {
            return "UnknownTask";
        }
        String className = task.getClass().getName();
        if (className.indexOf("$$Lambda$") >= 0 || className.indexOf("$Lambda") >= 0) {
            return "Lambda";
        }
        int dollarIndex = className.lastIndexOf(36);
        if (dollarIndex >= 0 && dollarIndex < className.length() - 1) {
            boolean isAnonymous = true;
            for (int i = dollarIndex + 1; i < className.length(); ++i) {
                char c = className.charAt(i);
                if (c >= '0' && c <= '9') continue;
                isAnonymous = false;
                break;
            }
            if (isAnonymous) {
                String outerClass = className.substring(0, dollarIndex);
                int lastDot = outerClass.lastIndexOf(46);
                String simpleName = lastDot >= 0 ? outerClass.substring(lastDot + 1) : outerClass;
                return simpleName + "$Anonymous";
            }
        }
        if (className.endsWith("FutureTask")) {
            return "FutureTask";
        }
        int lastDot = className.lastIndexOf(46);
        return lastDot >= 0 ? className.substring(lastDot + 1) : className;
    }

    public static Callable beforeSubmitCallable(Callable task, Executor executor) {
        int depth = ExecutorCallDepthMap.forClass(executor.getClass()).getAndIncrement();
        try {
            if (depth > 0) {
                return task;
            }
            if (TaskClassFilter.shouldExclude(task)) {
                return task;
            }
            if (!ConfTrace.trace_executor_enabled) {
                return task;
            }
            TraceContext parentCtx = TraceContextManager.getLocalContext();
            if (parentCtx == null) {
                return task;
            }
            if (task instanceof ContextPropagatingCallable) {
                return task;
            }
            String taskName = ExecutorAdvice.getTaskName(task);
            if (parentCtx.mtid == 0L) {
                parentCtx.mtid = KeyGen.next();
                parentCtx.mtid_build_checked = true;
            }
            ExecutorContext execCtx = new ExecutorContext(parentCtx);
            execCtx.taskName = taskName;
            execCtx.initChildTransaction(taskName);
            ContextPropagatingCallable wrapped = new ContextPropagatingCallable(task, execCtx);
            if (ConfInstrumentation.debug_instrumentation_executor_enabled) {
                Logger.println("Executor", "beforeSubmitCallable WRAPPED: task=" + taskName + ", parentTxid=" + parentCtx.txid + (execCtx.childContext != null ? ", childTxid=" + execCtx.childContext.txid : ""));
            }
            return wrapped;
        }
        catch (Throwable t) {
            Logger.println("Executor", 10, "beforeSubmitCallable ERROR: " + t);
            return task;
        }
    }

    public static void afterSubmitCallable(Executor executor) {
        try {
            ExecutorCallDepthMap.forClass(executor.getClass()).decrementAndGet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getTaskName(Callable task) {
        int lastDot;
        if (task == null) {
            return "UnknownTask";
        }
        String className = task.getClass().getName();
        if (className.indexOf("$$Lambda$") >= 0 || className.indexOf("$Lambda") >= 0) {
            return "Lambda";
        }
        int dollarIndex = className.lastIndexOf(36);
        if (dollarIndex >= 0 && dollarIndex < className.length() - 1) {
            boolean isAnonymous = true;
            for (int i = dollarIndex + 1; i < className.length(); ++i) {
                char c = className.charAt(i);
                if (c >= '0' && c <= '9') continue;
                isAnonymous = false;
                break;
            }
            if (isAnonymous) {
                String outerClass = className.substring(0, dollarIndex);
                int lastDot2 = outerClass.lastIndexOf(46);
                String simpleName = lastDot2 >= 0 ? outerClass.substring(lastDot2 + 1) : outerClass;
                return simpleName + "$Anonymous";
            }
        }
        return (lastDot = className.lastIndexOf(46)) >= 0 ? className.substring(lastDot + 1) : className;
    }
}

