/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.adapter;

import whatap.agent.asm.IASM;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

public class ExecuteMethodAdapter
extends LocalVariablesSorter
implements Opcodes {
    private static final String ADVICE_CLASS = "whatap/agent/instrumentation/executor/advice/ExecutorAdvice";
    private static final String BEFORE_METHOD = "beforeExecute";
    private static final String BEFORE_DESC = "(Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/lang/Runnable;";
    private static final String AFTER_METHOD = "afterExecute";
    private static final String AFTER_DESC = "(Ljava/util/concurrent/Executor;)V";
    private final String owner;
    private final boolean isStatic;
    private final Label startFinally = new Label();

    public ExecuteMethodAdapter(int access, String descriptor, MethodVisitor mv, String owner, boolean isStatic) {
        super(IASM.API, access, descriptor, mv);
        this.owner = owner;
        this.isStatic = isStatic;
    }

    public void visitCode() {
        this.mv.visitCode();
        int commandSlot = this.isStatic ? 0 : 1;
        this.mv.visitVarInsn(25, commandSlot);
        if (this.isStatic) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitMethodInsn(184, ADVICE_CLASS, BEFORE_METHOD, BEFORE_DESC, false);
        this.mv.visitVarInsn(58, commandSlot);
        this.mv.visitLabel(this.startFinally);
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.emitAfterExecute();
        }
        this.mv.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.emitAfterExecute();
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 4, maxLocals + 2);
    }

    private void emitAfterExecute() {
        if (this.isStatic) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitMethodInsn(184, ADVICE_CLASS, AFTER_METHOD, AFTER_DESC, false);
    }
}

