/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor;

import whatap.agent.Logger;
import whatap.agent.conf.ConfInstrumentation;

public class TaskClassFilter {
    private static String lastPatternStr;
    private static String[] cachedPatterns;

    public static boolean shouldExclude(Object task) {
        if (task == null) {
            return true;
        }
        String excludePatterns = ConfInstrumentation.instrumentation_executor_exclude_task_prefixes;
        if (excludePatterns == null || excludePatterns.isEmpty()) {
            return false;
        }
        String className = task.getClass().getName();
        String[] patterns = TaskClassFilter.getPatterns(excludePatterns);
        for (int i = 0; i < patterns.length; ++i) {
            if (patterns[i].length() <= 0 || !className.startsWith(patterns[i])) continue;
            if (ConfInstrumentation.debug_instrumentation_executor_enabled) {
                Logger.println("Executor", "TaskClassFilter EXCLUDED: " + className + " (pattern: " + patterns[i] + ")");
            }
            return true;
        }
        return false;
    }

    private static String[] getPatterns(String patternStr) {
        if (patternStr == lastPatternStr) {
            return cachedPatterns;
        }
        String[] parsed = patternStr.split(",");
        for (int i = 0; i < parsed.length; ++i) {
            parsed[i] = parsed[i].trim();
        }
        cachedPatterns = parsed;
        lastPatternStr = patternStr;
        return parsed;
    }
}

