/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.conf.ConfInstrumentation;
import whatap.agent.instrumentation.executor.visitor.AbstractExecutorServiceClassVisitor;
import whatap.agent.instrumentation.executor.visitor.ExecutorClassVisitor;
import whatap.agent.instrumentation.executor.visitor.ForkJoinPoolClassVisitor;
import whatap.agent.instrumentation.executor.visitor.ScheduledExecutorClassVisitor;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.SystemUtil;

public class ExecutorInstrumentation
extends IASM
implements Opcodes {
    private static final HashSet<String> TARGET_CLASSES = new HashSet();

    public void reserved(ReservedSet classSet) {
        classSet.addClass(TARGET_CLASSES);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.isTargetClass(className)) {
            return cv;
        }
        if (ConfInstrumentation.debug_instrumentation_executor_enabled) {
            Logger.println("Executor", "transforming: " + className);
        }
        if ("java/util/concurrent/AbstractExecutorService".equals(className)) {
            return new AbstractExecutorServiceClassVisitor(cv, className);
        }
        if ("java/util/concurrent/ThreadPoolExecutor".equals(className)) {
            return new ExecutorClassVisitor(cv, className);
        }
        if ("java/util/concurrent/Executors$DelegatedExecutorService".equals(className) || "java/util/concurrent/Executors$FinalizableDelegatedExecutorService".equals(className)) {
            return new ExecutorClassVisitor(cv, className);
        }
        if ("java/util/concurrent/ThreadPerTaskExecutor".equals(className) || "java/util/concurrent/Executors$ThreadPerTaskExecutor".equals(className)) {
            return new ExecutorClassVisitor(cv, className);
        }
        if (("java/util/concurrent/ScheduledThreadPoolExecutor".equals(className) || "java/util/concurrent/Executors$DelegatedScheduledExecutorService".equals(className)) && ConfInstrumentation.instrumentation_executor_scheduled_enabled) {
            return new ScheduledExecutorClassVisitor(cv);
        }
        if ("java/util/concurrent/ForkJoinPool".equals(className) && ConfInstrumentation.instrumentation_executor_forkjoin_enabled) {
            return new ForkJoinPoolClassVisitor(cv);
        }
        return cv;
    }

    private boolean isTargetClass(String className) {
        return TARGET_CLASSES.contains(className);
    }

    static {
        TARGET_CLASSES.add("java/util/concurrent/AbstractExecutorService");
        TARGET_CLASSES.add("java/util/concurrent/ThreadPoolExecutor");
        TARGET_CLASSES.add("java/util/concurrent/ScheduledThreadPoolExecutor");
        TARGET_CLASSES.add("java/util/concurrent/ForkJoinPool");
        TARGET_CLASSES.add("java/util/concurrent/Executors$DelegatedExecutorService");
        TARGET_CLASSES.add("java/util/concurrent/Executors$FinalizableDelegatedExecutorService");
        TARGET_CLASSES.add("java/util/concurrent/Executors$DelegatedScheduledExecutorService");
        if (SystemUtil.getMajorVersion() >= 65) {
            TARGET_CLASSES.add("java/util/concurrent/ThreadPerTaskExecutor");
            TARGET_CLASSES.add("java/util/concurrent/Executors$ThreadPerTaskExecutor");
        }
    }
}

