/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataPackSender;
import whatap.agent.net.Sender;
import whatap.agent.net.TcpRequestMgr;
import whatap.io.DataOutputX;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.ZipPack;
import whatap.util.AnsiPrint;
import whatap.util.CompressUtil;
import whatap.util.DateUtil;
import whatap.util.RequestQueue;
import whatap.util.ThreadUtil;

public class ZipProfileThread
extends Thread {
    private static ZipProfileThread instance;
    RequestQueue<AbstractPack> queue = new RequestQueue(ConfTrace.trace_zip_queue_size);
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    int packCount = 0;
    long first_time;
    SecurityMaster secuMaster = SecurityMaster.getInstance();
    Configure conf = Configure.getInstance();
    long last_log;
    long zip_sent = 0L;
    long no_zip_sent = 0L;

    public static final synchronized ZipProfileThread getInstance() {
        if (instance == null) {
            instance = new ZipProfileThread();
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    private ZipProfileThread() {
        ConfObserver.add("ZipProfileThread", new Runnable(){

            public void run() {
                ZipProfileThread.this.queue.setCapacity(ConfTrace.trace_zip_queue_size);
            }
        });
    }

    public void add(AbstractPack p) {
        boolean ok = this.queue.put(p);
        if (!ok) {
            DataPackSender.send(p);
            ++this.no_zip_sent;
        }
    }

    public void addWait(AbstractPack p, long waitTimeForFull) {
        boolean ok = this.queue.put(p);
        if (!ok && waitTimeForFull > 0L) {
            while (!this.queue.put(p)) {
                ThreadUtil.sleep(waitTimeForFull);
            }
        }
    }

    public void run() {
        while (true) {
            AbstractPack log = this.queue.get(ConfTrace.trace_zip_max_wait_time);
            try {
                if (log != null) {
                    this.append(log);
                    continue;
                }
                this.sendAndClear();
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void append(AbstractPack p) throws IOException {
        byte[] b = DataOutputX.toBytes(p);
        if (b.length >= this.conf.net_send_max_bytes) {
            Sender.handleOverflow(p, b.length);
            return;
        }
        this.buffer.write(b);
        ++this.packCount;
        if (this.first_time == 0L) {
            this.first_time = p.time;
            if (this.buffer.size() >= ConfTrace.trace_zip_max_buffer_size) {
                this.sendAndClear();
            }
        } else if (this.buffer.size() >= ConfTrace.trace_zip_max_buffer_size || p.time - this.first_time >= (long)ConfTrace.trace_zip_max_wait_time) {
            this.sendAndClear();
        }
    }

    private void sendAndClear() {
        if (this.buffer.size() == 0) {
            return;
        }
        ZipPack p = new ZipPack();
        p.time = DateUtil.currentTime();
        p.recordCount = this.packCount;
        p.records = this.buffer.toByteArray();
        this.doZip(p);
        if (ConfTrace.debug_trace_zip_enabled) {
            if (ConfTrace.debug_trace_zip_interval <= 0) {
                Logger.println("PROFILE " + AnsiPrint.green(" status=" + p.status + " records=" + p.recordCount + " | " + this.buffer.size() + "=>" + p.records.length + " queue=" + this.queue.size()));
            } else {
                ++this.zip_sent;
                long now = System.currentTimeMillis();
                if (now > this.last_log + (long)ConfTrace.debug_trace_zip_interval) {
                    this.last_log = now;
                    this.log(p);
                    this.zip_sent = 0L;
                }
            }
        }
        p.pcode = this.secuMaster.PCODE;
        p.oid = this.secuMaster.OID;
        p.okind = this.conf.OKIND;
        p.onode = this.conf.ONODE;
        TcpRequestMgr.getInstance().addProfile(0, false, p);
        this.buffer.reset();
        this.first_time = 0L;
        this.packCount = 0;
    }

    private void log(ZipPack p) {
        StringBuilder sb = new StringBuilder();
        sb.append("PROFILE ").append("\u001b[32m");
        sb.append("zip_sent=").append(this.zip_sent);
        sb.append(" records=").append(p.recordCount);
        sb.append(" | ").append(this.buffer.size()).append("=>").append(p.records.length);
        sb.append(" queue=").append(this.queue.size());
        if (this.no_zip_sent > 0L) {
            sb.append(" no_zip_sent=").append(this.no_zip_sent);
        }
        sb.append("\u001b[0m");
        Logger.println(sb.toString());
    }

    private void doZip(ZipPack p) {
        if (p.status != 0) {
            return;
        }
        if (p.records.length < ConfTrace.trace_zip_min_size) {
            return;
        }
        p.status = 1;
        p.records = CompressUtil.doZip(p.records);
    }

    public void flush() {
        while (this.queue.size() > 0) {
            ThreadUtil.sleep(10L);
        }
        this.sendAndClear();
    }
}

