/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfOpenMx;
import whatap.agent.conf.ConfStat;
import whatap.agent.conf.ConfThrottle;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.BlockingDetect;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.data.ZipProfileThread;
import whatap.agent.open.OpenMxEng;
import whatap.agent.stat.StatRemoteIPURL;
import whatap.agent.stat.StatRemoteIp;
import whatap.agent.stat.StatTranx;
import whatap.agent.stat.StatTranxDomain;
import whatap.agent.stat.StatTranxLogin;
import whatap.agent.stat.StatTranxMtCaller;
import whatap.agent.stat.StatTranxReferer;
import whatap.agent.stat.StatTranxStatus;
import whatap.agent.stat.StatUserAgent;
import whatap.agent.trace.TraceContext;
import whatap.lang.pack.ProfilePack;
import whatap.lang.pack.TimeCount;
import whatap.lang.pack.TransactionRec;
import whatap.lang.service.TxRecord;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MessageStepX;
import whatap.lang.step.Step;
import whatap.util.HashUtil;

public class DataProfileAgent {
    private static long last_reject = 0L;
    private static final int HTTP_HEADERS_HASH = HashUtil.hash("HTTP-HEADERS");
    private static StatUserAgent statUserAgent = StatUserAgent.getInstance();
    private static StatRemoteIp statRemoteIp = StatRemoteIp.getInstance();
    private static StatTranx statTranx = StatTranx.getInstance();
    private static StatTranxLogin statTranxLogin = StatTranxLogin.getInstance();
    private static StatTranxDomain statTranxDomain = StatTranxDomain.getInstance();
    private static StatTranxReferer statTranxReferer = StatTranxReferer.getInstance();
    private static StatTranxMtCaller statTranxMtCaller = StatTranxMtCaller.getInstance();
    private static StatRemoteIPURL statRemoteIpURL = StatRemoteIPURL.getInstance();
    private static StatTranxStatus statTranxStatus = StatTranxStatus.getInstance();

    public static void sendProfile(TraceContext ctx, ProfilePack profile, boolean rejected) {
        TransactionRec stat;
        TimeCount tc;
        TxRecord tx = profile.transaction;
        if (ConfStat.stat_ip_enabled) {
            statRemoteIp.incRemoteIp(ctx.remoteIp);
        }
        if (ConfStat.stat_ipurl_enabled && ctx.remoteIp != 0 && (tc = statRemoteIpURL.getService(ctx.remoteIp, ctx.service_hash)) != null) {
            ++tc.count;
            if (tx.errorLevel >= 20) {
                ++tc.error;
            }
            tc.time += (long)tx.elapsed;
        }
        if (ConfStat.stat_status_url_enabled && ctx.status != 0 && (tc = statTranxStatus.getService(ctx.status, ctx.service_hash)) != null) {
            ++tc.count;
            if (tx.errorLevel >= 20) {
                ++tc.error;
            }
            tc.time += (long)tx.elapsed;
        }
        if (ConfStat.stat_useragent_enabled) {
            statUserAgent.incUserAgent(ctx.userAgent);
        }
        if (ctx.login != null) {
            tx.login = HashUtil.hash(ctx.login);
            DataTextAgent.LOGIN.add(tx.login, ctx.login);
            if (ConfStat.stat_login_enabled && (tc = statTranxLogin.getService(tx.login, ctx.service_hash)) != null) {
                ++tc.count;
                if (tx.errorLevel >= 20) {
                    ++tc.error;
                }
                tc.time += (long)tx.elapsed;
            }
        }
        if (ConfStat.stat_domain_enabled && ctx.http_host_hash != 0 && (tc = statTranxDomain.getService(ctx.http_host_hash, ctx.service_hash)) != null) {
            ++tc.count;
            if (tx.errorLevel >= 20) {
                ++tc.error;
            }
            tc.time += (long)tx.elapsed;
        }
        if (ConfStat.stat_referer_enabled && ctx.referer != 0 && (tc = statTranxReferer.getService(ctx.referer, ctx.service_hash)) != null) {
            ++tc.count;
            if (tx.errorLevel >= 20) {
                ++tc.error;
            }
            tc.time += (long)tx.elapsed;
        }
        if (ConfOpenMx.openmx_tx_status_enabled) {
            OpenMxEng.countTxByStatus(tx);
        }
        tx.mthis_spec = ConfMTrace.mtrace_spec_hash;
        if (ctx.mcaller_spec != null && ctx.mcaller_spec.length() > 0) {
            tx.mcaller_spec = HashUtil.hash(ctx.mcaller_spec);
            DataTextAgent.MTRACE_SPEC.add(tx.mcaller_spec, ctx.mcaller_spec);
        }
        if (ConfMTrace.stat_mtrace_enabled && ctx.mcaller_pcode != 0L) {
            StatTranxMtCaller.KEY key = new StatTranxMtCaller.KEY();
            key.caller_pcode = ctx.mcaller_pcode;
            key.caller_okind = ctx.mcaller_okind;
            key.caller_spec = tx.mcaller_spec;
            key.caller_url = tx.mcaller_url = ctx.mcaller_url_hash;
            key.url = ctx.service_hash;
            TimeCount tc2 = statTranxMtCaller.getService(key);
            if (tc2 != null) {
                ++tc2.count;
                if (tx.errorLevel >= 20) {
                    ++tc2.error;
                }
                tc2.time += (long)tx.elapsed;
            }
        }
        if ((stat = statTranx.getService(tx.service)) != null) {
            ++stat.count;
            if (tx.errorLevel >= 20) {
                ++stat.error;
            }
            stat.time_sum += (long)tx.elapsed;
            if (tx.elapsed > stat.time_max) {
                stat.time_max = tx.elapsed;
            }
            switch (tx.apdex) {
                case 2: {
                    ++stat.apdex_satisfied;
                    break;
                }
                case 1: {
                    ++stat.apdex_tolerated;
                }
            }
            if (stat.time_min == 0 || tx.elapsed < stat.time_min) {
                stat.time_min = tx.elapsed;
            }
            stat.time_sqr_sum += (long)tx.elapsed * (long)tx.elapsed;
            stat.sql_count += tx.sqlCount;
            stat.sql_time += (long)tx.sqlTime;
            stat.sql_fetch += (long)tx.sqlFetchCount;
            stat.sql_fetch_time += (long)tx.sqlFetchTime;
            stat.httpc_count += tx.httpcCount;
            stat.httpc_time += (long)tx.httpcTime;
            stat.malloc_sum += tx.malloc;
            stat.cpu_sum += (long)tx.cpuTime;
            if (!ctx.addMeterServiceEnabled) {
                ++stat.drop_profile;
                return;
            }
            if (rejected) {
                long now = System.currentTimeMillis();
                if (now < last_reject + 1000L) {
                    return;
                }
                last_reject = now;
            } else {
                boolean dropProfile = false;
                if (stat.profiled && tx.elapsed < ConfTrace.trace_basetime && (ctx.mtid == 0L || tx.elapsed < ConfMTrace.mtrace_basetime)) {
                    dropProfile = true;
                }
                if (ConfTrace.trace_service_background_error_only_enabled && ctx.isBackground) {
                    dropProfile = true;
                }
                if (!ConfTrace.trace_background_empty_profile_enabled && ctx.isBackground && !ctx.profile.hasStep()) {
                    dropProfile = true;
                }
                if (dropProfile && (!ConfTrace.trace_concern_error_enabled || tx.errorLevel < 20)) {
                    ++stat.drop_profile;
                    return;
                }
            }
            stat.profiled = true;
            stat.appctx = tx.appctx;
        }
        if (ConfThrottle.blocking_detect_enabled && tx.elapsed >= ConfThrottle.blocking_detect_time) {
            BlockingDetect.getInstance().add(ctx.service_hash, ctx.service_name, tx.endTime, tx.elapsed);
        }
        if (!ConfTrace.trace_send_enabled) {
            return;
        }
        Step[] steps = ctx.profile.getSteps();
        if (!ConfTrace.trace_header_only_enabled && DataProfileAgent.isSingleHttpHeaderProfile(steps)) {
            steps = new Step[]{};
        }
        try {
            tx.step_split_count = ctx.profile.getSplitCount();
            tx.active = ctx.profileActive > 0;
            profile.setProfile(steps);
            if (ConfTrace.trace_zip_enabled) {
                ZipProfileThread.getInstance().add(profile);
            } else {
                DataPackSender.send(profile);
            }
        }
        catch (Throwable t) {
            Logger.println("TxTrace", 10, t.toString());
        }
    }

    private static boolean isSingleHttpHeaderProfile(Step[] steps) {
        if (steps == null || steps.length != 1) {
            return false;
        }
        return DataProfileAgent.isHttpHeaderStep(steps[0]);
    }

    private static boolean isHttpHeaderStep(Step step) {
        if (step == null) {
            return false;
        }
        if (step instanceof MessageStep) {
            return ((MessageStep)step).hash == HTTP_HEADERS_HASH;
        }
        if (step instanceof MessageStepX) {
            return "HTTP-HEADERS".equals(((MessageStepX)step).title);
        }
        return false;
    }

    public static void sendChildProfile(TraceContext ctx, ProfilePack profile, boolean rejected) {
        TxRecord tx = profile.transaction;
        if (!ConfTrace.trace_send_enabled) {
            return;
        }
        Step[] steps = ctx.profile.getSteps();
        if (!ConfTrace.trace_header_only_enabled && DataProfileAgent.isSingleHttpHeaderProfile(steps)) {
            steps = new Step[]{};
        }
        try {
            tx.step_split_count = ctx.profile.getSplitCount();
            tx.active = ctx.profileActive > 0;
            profile.setProfile(steps);
            if (ConfTrace.trace_zip_enabled) {
                ZipProfileThread.getInstance().add(profile);
            } else {
                DataPackSender.send(profile);
            }
        }
        catch (Throwable t) {
            Logger.println("TxTrace", 10, t.toString());
        }
    }
}

