/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import java.util.ArrayList;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.net.TcpRequestMgr;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.ActiveStackPack1;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.ErrorSnapPack1;
import whatap.lang.pack.EventPack;
import whatap.lang.pack.HitMapPack1;
import whatap.lang.pack.LogSinkPack;
import whatap.lang.pack.LogSinkZipPack;
import whatap.lang.pack.ParamPack;
import whatap.lang.pack.ProfilePack;
import whatap.lang.pack.RealtimeUserPack1;
import whatap.lang.pack.StatErrorPack;
import whatap.lang.pack.StatGeneralPack;
import whatap.lang.pack.StatHttpcPack;
import whatap.lang.pack.StatRemoteIpPack;
import whatap.lang.pack.StatSqlPack;
import whatap.lang.pack.StatStatusPack;
import whatap.lang.pack.StatTransactionPack;
import whatap.lang.pack.StatUserAgentPack1;
import whatap.lang.pack.TagCountPack;
import whatap.lang.pack.TextPack;
import whatap.lang.pack.ZipPack;
import whatap.lang.pack.bsm.BsmRecordPack;
import whatap.logsink.workspace.LogSinkInfo;
import whatap.util.CompressUtil;
import whatap.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPackSender {
    static SecurityMaster secuMaster = SecurityMaster.getInstance();
    private static Configure conf = Configure.getInstance();

    public static void sendTest(CounterPack1 p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.apType = 1;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(CounterPack1 p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        p.apType = 1;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
        if (DataPackSender.conf.debug_param_keepalive_pack_enabled) {
            Logger.println("CounterPack1 Send Time :" + DateUtil.ymdhms(DateUtil.currentTime()));
        }
    }

    public static void sendSimula(CounterPack1 p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.apType = 1;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(StatGeneralPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(BsmRecordPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(HitMapPack1 p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void sendHitMap(AbstractPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(ActiveStackPack1 p, boolean flush) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().addProfile(0, flush, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().addProfile(1, flush, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().addProfile(2, flush, p);
            }
        }
    }

    public static AbstractPack setInfo(AbstractPack p) {
        if (p.time == 0L) {
            p.time = DateUtil.currentTime();
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        return p;
    }

    public static void sendActiveStackZip(List<AbstractPack> packs) {
        ZipPack zp = new ZipPack();
        zp.pcode = DataPackSender.secuMaster.PCODE;
        zp.oid = DataPackSender.secuMaster.OID;
        zp.time = DateUtil.currentTime();
        zp.setRecords(packs);
        zp.status = 1;
        zp.records = CompressUtil.doZip(zp.records);
        TcpRequestMgr.getInstance().addProfile(1, false, zp);
    }

    public static void sentZip(AbstractPack p) {
        DataPackSender.setInfo(p);
        ZipPack zp = new ZipPack();
        zp.pcode = p.pcode;
        zp.oid = p.oid;
        zp.time = DateUtil.currentTime();
        ArrayList<AbstractPack> packs = new ArrayList<AbstractPack>();
        packs.add(p);
        zp.setRecords(packs);
        zp.status = 1;
        zp.records = CompressUtil.doZip(zp.records);
        TcpRequestMgr.getInstance().add(1, true, zp);
    }

    public static void sent(TextPack p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.time = DateUtil.currentTime();
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(2, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(ErrorSnapPack1 p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.time = DateUtil.currentTime();
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(ProfilePack p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        if (p.time == 0L) {
            p.time = DateUtil.currentTime();
        }
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().addProfile(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().addProfile(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().addProfile(2, false, p);
            }
        }
    }

    public static void send(StatTransactionPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(StatSqlPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(StatHttpcPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(StatErrorPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(RealtimeUserPack1 p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(StatRemoteIpPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(StatStatusPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(StatUserAgentPack1 p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void sendBoot(ParamPack p) {
        if (p == null) {
            return;
        }
        p.id = 2;
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        p.time = DateUtil.currentTime();
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(2, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void sendShutdownSignal() {
        ParamPack p = new ParamPack();
        p.id = 111;
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        p.time = DateUtil.currentTime();
        p.put("shutdown", 1L);
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(0, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void sendCompVer(ParamPack p) {
        p.id = 5;
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        p.time = DateUtil.currentTime();
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, false, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, false, p);
            }
        }
    }

    public static void send(TagCountPack p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.putTag("oname", DataPackSender.secuMaster.ONAME);
        if (DataPackSender.conf.OKIND != 0) {
            p.okind = DataPackSender.conf.OKIND;
            p.putTag("okindName", DataPackSender.conf.OKIND_NAME);
        }
        if (DataPackSender.conf.ONODE != 0) {
            p.onode = DataPackSender.conf.ONODE;
            p.putTag("onodeName", DataPackSender.conf.ONODE_NAME);
        }
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void sendCompact(TagCountPack p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(AbstractPack p) {
        DataPackSender.send(p, false);
    }

    public static void send(AbstractPack p, boolean flush) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, flush, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(1, flush, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, flush, p);
            }
        }
    }

    public static void sendLogSink(LogSinkPack p, boolean flush) {
        if (SecurityMaster.isWorkspace) {
            if (LogSinkInfo.SYSID == 0) {
                return;
            }
            p.pcode = LogSinkInfo.getPcode();
            p.oid = LogSinkInfo.getOid();
        } else {
            p.pcode = DataPackSender.secuMaster.PCODE;
            p.oid = DataPackSender.secuMaster.OID;
        }
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        int flag = ConfLogSink.logsink_high_secure_enabled ? 2 : 1;
        if (SecurityMaster.isWorkspace) {
            flag |= 0x10;
        }
        TcpRequestMgr.getInstance().addProfile(flag, flush, p);
    }

    public static void sendLogSink(ZipPack p) {
        if (SecurityMaster.isWorkspace) {
            if (LogSinkInfo.SYSID == 0) {
                return;
            }
            p.pcode = LogSinkInfo.getPcode();
            p.oid = LogSinkInfo.getOid();
        } else {
            p.pcode = DataPackSender.secuMaster.PCODE;
            p.oid = DataPackSender.secuMaster.OID;
        }
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        int flag = 0;
        if (ConfLogSink.logsink_high_secure_enabled) {
            flag = 2;
        }
        if (SecurityMaster.isWorkspace) {
            flag |= 0x10;
        }
        TcpRequestMgr.getInstance().addProfile(flag, false, p);
    }

    public static void sendLogSink(LogSinkZipPack p) {
        if (SecurityMaster.isWorkspace) {
            if (LogSinkInfo.SYSID == 0) {
                return;
            }
            p.pcode = LogSinkInfo.getPcode();
            p.oid = LogSinkInfo.getOid();
        } else {
            p.pcode = DataPackSender.secuMaster.PCODE;
            p.oid = DataPackSender.secuMaster.OID;
        }
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        int flag = 0;
        if (ConfLogSink.logsink_high_secure_enabled) {
            flag = 2;
        }
        if (SecurityMaster.isWorkspace) {
            flag |= 0x10;
        }
        TcpRequestMgr.getInstance().addProfile(flag, false, p);
    }

    public static void sendResponse(ParamPack p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(2, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void sendResponseHide(ParamPack p) {
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(2, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void send(EventPack p) {
        if (p == null) {
            return;
        }
        p.pcode = DataPackSender.secuMaster.PCODE;
        p.oid = DataPackSender.secuMaster.OID;
        p.time = DateUtil.currentTime();
        p.okind = DataPackSender.conf.OKIND;
        p.onode = DataPackSender.conf.ONODE;
        p.setUuid();
        if (ConfDebug.debug_event_enabled) {
            Logger.info("EVENT", p.toString());
        }
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(1, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(2, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(2, true, p);
            }
        }
    }

    public static void sendOneWay(AbstractPack p, boolean flush) {
        if (p.pcode == 0L) {
            p.pcode = DataPackSender.secuMaster.PCODE;
            p.oid = DataPackSender.secuMaster.OID;
            p.okind = DataPackSender.conf.OKIND;
            p.onode = DataPackSender.conf.ONODE;
        }
        p.time = DateUtil.currentTime();
        TcpRequestMgr.getInstance().add(4, flush, p);
    }

    public static void sendToRouter(AbstractPack p) {
        if (p == null) {
            return;
        }
        if (p.pcode == 0L) {
            p.pcode = DataPackSender.secuMaster.PCODE;
        }
        if (p.oid == 0) {
            p.oid = DataPackSender.secuMaster.OID;
        }
        p.time = DateUtil.currentTime();
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(8, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(9, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(10, true, p);
            }
        }
    }

    public static void sendRerouteTarget(AbstractPack p) {
        if (p == null) {
            return;
        }
        if (p.pcode == 0L) {
            p.pcode = DataPackSender.secuMaster.PCODE;
        }
        if (p.oid == 0) {
            p.oid = DataPackSender.secuMaster.OID;
        }
        p.time = DateUtil.currentTime();
        switch (DataPackSender.conf.encrypt_level) {
            case 1: {
                TcpRequestMgr.getInstance().add(16, true, p);
                break;
            }
            case 2: {
                TcpRequestMgr.getInstance().add(17, true, p);
                break;
            }
            default: {
                TcpRequestMgr.getInstance().add(18, true, p);
            }
        }
    }
}

