/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import whatap.agent.Logger;
import whatap.agent.counter.task.res.util.JmxProxy;
import whatap.util.CastUtil;

public class JmxIBMProxy
implements JmxProxy {
    boolean isOk;
    boolean isMemOk;
    Method getTotalPhysicalMemory;
    Method getFreePhysicalMemorySize;
    int cores = 1;
    OperatingSystemMXBean bean;

    public JmxIBMProxy() {
        try {
            this.bean = ManagementFactory.getOperatingSystemMXBean();
            this.isOk = true;
            this.cores = this.bean.getAvailableProcessors();
            try {
                this.getTotalPhysicalMemory = this.bean.getClass().getMethod("getTotalPhysicalMemory", new Class[0]);
                this.getFreePhysicalMemorySize = this.bean.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]);
                this.isMemOk = true;
                Logger.println("A149", 10, "PerfSysIBM initialized");
            }
            catch (Throwable e) {
                Logger.println("A148", 10, "PerfSysIBM init error", e);
                this.getTotalPhysicalMemory = null;
                this.getFreePhysicalMemorySize = null;
            }
        }
        catch (Throwable t) {
            Logger.info("I112", "PerfSysIBM " + t.getMessage());
        }
    }

    public float cpu() {
        if (!this.isOk) {
            return 0.0f;
        }
        try {
            return (float)this.bean.getSystemLoadAverage();
        }
        catch (Exception e) {
            this.isOk = false;
            return 0.0f;
        }
    }

    public float processCpu() {
        return 0.0f;
    }

    public float mem() {
        if (!this.isMemOk) {
            return 0.0f;
        }
        try {
            long t = CastUtil.clong(this.getTotalPhysicalMemory.invoke((Object)this.bean, null));
            if (t == 0L) {
                this.isMemOk = false;
                return 0.0f;
            }
            long f = CastUtil.clong(this.getFreePhysicalMemorySize.invoke((Object)this.bean, null));
            return (float)(t - f) * 100.0f / (float)t;
        }
        catch (Exception e) {
            this.isMemOk = false;
            return 0.0f;
        }
    }

    public long memUseTotal() {
        try {
            return CastUtil.clong(this.getTotalPhysicalMemory.invoke((Object)this.bean, null));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public float swap() {
        return 0.0f;
    }
}

