/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools.other;

import java.lang.management.ManagementFactory;
import java.util.Enumeration;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.data.DataTextAgent;
import whatap.util.CastUtil;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.LinkedMap;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class TomcatDataSource {
    protected static LinkedMap<ObjectName, String> dataSourceSet = new LinkedMap();
    private static boolean initflag = false;
    static StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

        @Override
        protected CNT create(String key) {
            return new CNT();
        }
    };
    static boolean urlOk = true;

    public static void process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (ConfPool.pool_detail_enabled) {
            detail.clear();
        }
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (!initflag) {
                try {
                    Set<ObjectName> ds = server.queryNames(null, new ObjectName("*:type=DataSource,*"));
                    for (ObjectName o : ds) {
                        String jndi = StringUtil.strip(o.getKeyProperty("name"), '\"');
                        dataSourceSet.put(o, jndi);
                    }
                }
                catch (Exception e) {
                    Logger.println("TomcatDataSource", e.toString());
                }
            }
            initflag = true;
            Enumeration<ObjectName> en = dataSourceSet.keys();
            while (en.hasMoreElements()) {
                ObjectName oi = en.nextElement();
                try {
                    String jndi = dataSourceSet.get(oi);
                    try {
                        if (urlOk) {
                            jndi = CastUtil.cString(server.getAttribute(oi, "url"));
                        }
                    }
                    catch (Exception localException1) {
                        urlOk = false;
                    }
                    int hash = HashUtil.hash(jndi);
                    DataTextAgent.dbc(hash, jndi);
                    int numActive = CastUtil.cint(server.getAttribute(oi, "numActive"));
                    int numIdle = CastUtil.cint(server.getAttribute(oi, "numIdle"));
                    if (ConfPool.pool_detail_enabled) {
                        detail.intern(jndi).add(numActive, numIdle);
                    }
                    db_num_active.add(hash, numActive);
                    db_num_idle.add(hash, numIdle);
                }
                catch (Exception e) {
                    dataSourceSet.remove(oi);
                }
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail("DataSource", detail);
            }
        }
        catch (Exception ee) {
            Logger.println("TomcatDataSource", 3600000, ee.toString());
        }
    }
}

