/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.util.HashUtil;
import whatap.util.IntIntLinkedMap;
import whatap.util.IntIntMap;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntLongLinkedMap;
import whatap.util.StringKeyLinkedMap;

public class WebLogicConnPool
implements IConnPoolObject {
    public static String classNameId = "WebLogicConnPool";
    private static int ok = 10;
    private static IntIntLinkedMap nameMap = new IntIntLinkedMap().setMax(1000);
    private static IntKeyLinkedMap<String> nameStrMap = new IntKeyLinkedMap().setMax(500);
    private static IntLongLinkedMap checkMap = new IntLongLinkedMap().setMax(1000);

    public String id() {
        return classNameId;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (!ConfPool.weblogic_pool_enabled) {
            return false;
        }
        StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

            @Override
            protected CNT create(String key) {
                return new CNT();
            }
        };
        try {
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(classNameId);
            while (poolEnum.hasMoreElements()) {
                Object pool = poolEnum.nextElement().get();
                try {
                    if (pool == null) continue;
                    int oHash = System.identityHashCode(pool);
                    int nameHash = nameMap.get(oHash);
                    if (nameHash == 0) {
                        long now = System.currentTimeMillis();
                        long last = checkMap.get(oHash);
                        if (last + 21600000L < now) {
                            String getName = PoolObjectReflect.getStringNoException(pool, "getName");
                            if (getName == null && (getName = PoolObjectReflect.getStringNoException(pool, "getURL")) == null) {
                                getName = pool.getClass().getName();
                            }
                            nameHash = HashUtil.hash(getName);
                            DataTextAgent.dbc(nameHash, getName);
                            nameStrMap.put(nameHash, getName);
                            nameMap.put(nameHash, nameHash);
                            checkMap.put(nameHash, now);
                        }
                    }
                    int numAct = PoolObjectReflect.getInt(pool, "getNumUnavailable");
                    int numIdle = PoolObjectReflect.getInt(pool, "getNumAvailable");
                    db_num_active.add(nameHash, numAct);
                    db_num_idle.add(nameHash, numIdle);
                    if (!ConfPool.pool_detail_enabled) continue;
                    String name = nameStrMap.get(nameHash);
                    if (!ConfPool.pool_detail_enabled) continue;
                    ((CNT)detail.intern(name)).add(numAct, numIdle);
                    if (!ConfPool.debug_pool_detail_enabled) continue;
                    Logger.println("DBPOOL", classNameId + ": pool=" + name + " act=" + numAct + " idle=" + numIdle);
                }
                catch (Exception e) {
                    Logger.println("WebLogicConnPool", 3600000, e.toString() + ",hotfix: weblogic_pool_enabled=false");
                }
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail(classNameId, detail);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.println("WebLogicConnPool", 3600000, e + ",hotfix: weblogic_pool_enabled=false");
            return false;
        }
    }
}

