/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;

public class JBossConnPool
implements IConnPoolObject {
    public static String className = "JBossConnPool";
    static int classNameHash = HashUtil.hash(className);
    private static int argsErrCnt = 10;
    private static Boolean hasGetInUseCount = null;
    private static Boolean hasGetActiveCount = null;
    private static Boolean hasGetIdleCount = null;
    private static Boolean hasGetAvailableCount = null;
    private static int getInUseCountRetries = 0;
    private static int getActiveCountRetries = 0;
    private static int getAvailableCountRetries = 0;
    private static int getIdleCountRetries = 0;
    private static final int MAX_RETRIES = 3;

    public String id() {
        return className;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (!ConfPool.jboss_pool_enabled) {
            return false;
        }
        try {
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(className);
            while (poolEnum.hasMoreElements()) {
                Object pool = poolEnum.nextElement().get();
                if (pool == null) continue;
                DataTextAgent.dbc(classNameHash, className);
                int act = this.getActiveConnectionsCount(pool);
                int idle = this.getIdleConnectionsCount(pool);
                db_num_active.add(classNameHash, act);
                db_num_idle.add(classNameHash, idle);
            }
            return true;
        }
        catch (Throwable e) {
            if (Logger.checkOk("JBossConnPool", 10)) {
                if (argsErrCnt > 0) {
                    --argsErrCnt;
                }
                Logger.println("JBossConnPool", 3600000, e + ", hotfix: jboss_pool_enabled=false");
            }
            return false;
        }
    }

    private int getActiveConnectionsCount(Object pool) {
        int act;
        block15: {
            block14: {
                act = 0;
                if (hasGetInUseCount != Boolean.FALSE) {
                    try {
                        act = PoolObjectReflect.getInt(pool, "getInUseCount");
                        hasGetInUseCount = Boolean.TRUE;
                        return act;
                    }
                    catch (NoSuchMethodException e) {
                        if (getInUseCountRetries < 3) {
                            Logger.println("JBossConnPool", "method getInUseCount not found, retry " + ++getInUseCountRetries + "/" + 3);
                        } else {
                            hasGetInUseCount = Boolean.FALSE;
                            Logger.println("JBossConnPool", "method getInUseCount not available");
                        }
                    }
                    catch (Throwable e) {
                        if (!Logger.checkOk("JBossConnPool", 10)) break block14;
                        if (argsErrCnt > 0) {
                            --argsErrCnt;
                        }
                        Logger.println("JBossConnPool", 3600000, e + ", hotfix: jboss_pool_enabled=false");
                    }
                }
            }
            if (hasGetActiveCount != Boolean.FALSE) {
                try {
                    act = PoolObjectReflect.getInt(pool, "getActiveCount");
                    hasGetActiveCount = Boolean.TRUE;
                    return act;
                }
                catch (NoSuchMethodException e) {
                    if (getActiveCountRetries < 3) {
                        Logger.println("JBossConnPool", "method getActiveCount not found, retry " + ++getActiveCountRetries + "/" + 3);
                    } else {
                        hasGetActiveCount = Boolean.FALSE;
                        Logger.println("JBossConnPool", "method getActiveCount confirmed as not available");
                    }
                }
                catch (Throwable e) {
                    if (!Logger.checkOk("JBossConnPool", 10)) break block15;
                    if (argsErrCnt > 0) {
                        --argsErrCnt;
                    }
                    Logger.println("JBossConnPool", 3600000, e + ", hotfix: jboss_pool_enabled=false");
                }
            }
        }
        return act;
    }

    private int getIdleConnectionsCount(Object pool) {
        int idle;
        block15: {
            block14: {
                idle = 0;
                if (hasGetIdleCount != Boolean.FALSE) {
                    try {
                        idle = PoolObjectReflect.getInt(pool, "getIdleCount");
                        hasGetIdleCount = Boolean.TRUE;
                        return idle;
                    }
                    catch (NoSuchMethodException e) {
                        if (getIdleCountRetries < 3) {
                            Logger.println("JBossConnPool", "method getIdleCount not found, retry " + ++getIdleCountRetries + "/" + 3);
                        } else {
                            hasGetIdleCount = Boolean.FALSE;
                            Logger.println("JBossConnPool", "method getIdleCount confirmed as not available");
                        }
                    }
                    catch (Throwable e) {
                        if (!Logger.checkOk("JBossConnPool", 10)) break block14;
                        if (argsErrCnt > 0) {
                            --argsErrCnt;
                        }
                        Logger.println("JBossConnPool", 3600000, e + ", hotfix: jboss_pool_enabled=false");
                    }
                }
            }
            if (hasGetAvailableCount != Boolean.FALSE) {
                try {
                    idle = PoolObjectReflect.getInt(pool, "getAvailableCount");
                    hasGetAvailableCount = Boolean.TRUE;
                    return idle;
                }
                catch (NoSuchMethodException e) {
                    if (getAvailableCountRetries < 3) {
                        Logger.println("JBossConnPool", "method getAvailableCount not found, retry " + ++getAvailableCountRetries + "/" + 3);
                    } else {
                        hasGetAvailableCount = Boolean.FALSE;
                        Logger.println("JBossConnPool", "method getAvailableCount confirmed as not available");
                    }
                }
                catch (Throwable e) {
                    if (!Logger.checkOk("JBossConnPool", 10)) break block15;
                    if (argsErrCnt > 0) {
                        --argsErrCnt;
                    }
                    Logger.println("JBossConnPool", 3600000, e + ", hotfix: jboss_pool_enabled=false");
                }
            }
        }
        return idle;
    }
}

