/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDiskUsage;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.util.DateUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

public class ThreadDiskUsage
extends Thread {
    private static ThreadDiskUsage instance;
    public boolean brun = true;
    static Field field;

    public static final synchronized ThreadDiskUsage getInstance() {
        if (instance == null) {
            instance = new ThreadDiskUsage();
            instance.setName("WhaTapDiskUsage");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public static void startThread() {
        if (ConfDiskUsage.diskusage_enabled) {
            ThreadDiskUsage.getInstance();
        }
    }

    public void run() {
        while (this.brun) {
            try {
                if (ConfDiskUsage.diskusage_enabled) {
                    this.process();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ThreadUtil.sleep(ConfDiskUsage.diskusage_interval);
        }
    }

    protected void process() {
        if (ConfDiskUsage.diskusage_default_enabled) {
            if (SystemUtil.IS_WINDOWS) {
                this.readDefaultWindow();
            } else {
                this.readDefaultLinux();
            }
        } else {
            this.readConfigured();
        }
    }

    protected void readDefaultLinux() {
        FileSystem fs = FileSystems.getDefault();
        for (FileStore store : fs.getFileStores()) {
            if (!store.name().startsWith("/dev/") || store.name().startsWith("/dev/loop")) continue;
            String id = store.name().substring("/dev/".length());
            String path = ThreadDiskUsage.getPath(store);
            try {
                this.exec(id, path, store);
            }
            catch (Throwable t) {
                Logger.println("disk_usage", id + " " + t);
            }
        }
    }

    protected void readDefaultWindow() {
        FileSystem fs = FileSystems.getDefault();
        for (FileStore store : fs.getFileStores()) {
            String id = store.name();
            String path = ThreadDiskUsage.getPath(store);
            try {
                this.exec(id, path, store);
            }
            catch (Throwable t) {
                Logger.println("disk_usage", id + " " + t);
            }
        }
    }

    protected void exec(String id, String path, FileStore store) throws IOException {
        long total = store.getTotalSpace();
        if (total > 0L) {
            long used = store.getTotalSpace() - store.getUnallocatedSpace();
            long avail = store.getUsableSpace();
            TagCountPack tag = new TagCountPack();
            tag.time = DateUtil.now() / 1000L * 1000L;
            tag.category = "disk_usage";
            tag.putTag("id", id);
            tag.putTag("path", path);
            tag.putTag("type", store.type());
            tag.put("total", total);
            tag.put("used", used);
            tag.put("avail", avail);
            tag.put("useRate", (double)used * 100.0 / (double)total);
            DataPackSender.send(tag);
            if (ConfDiskUsage.diskusage_debug_enabled) {
                Logger.yellow(tag.toString());
            }
        }
    }

    private static String getPath(FileStore st) {
        try {
            if (field == null) {
                field = SystemUtil.IS_WINDOWS ? Class.forName("sun.nio.fs.WindowsFileStore").getDeclaredField("root") : Class.forName("sun.nio.fs.UnixFileStore").getDeclaredField("file");
                field.setAccessible(true);
            }
            return field.get(st).toString();
        }
        catch (Exception e) {
            return st.name();
        }
    }

    protected void readConfigured() {
        try {
            StringKeyLinkedMap<String> dirs = ConfDiskUsage.diskusage_path;
            StringEnumer en = dirs.keys();
            while (en.hasMoreElements()) {
                String id = en.nextString();
                String path = dirs.get(id);
                try {
                    FileStore store = Files.getFileStore(Paths.get(path, new String[0]));
                    long total = store.getTotalSpace();
                    if (total == 0L) continue;
                    long used = store.getTotalSpace() - store.getUnallocatedSpace();
                    long avail = store.getUsableSpace();
                    TagCountPack tag = new TagCountPack();
                    tag.time = DateUtil.now() / 1000L * 1000L;
                    tag.category = "disk_usage";
                    tag.putTag("id", id);
                    tag.putTag("path", path);
                    tag.putTag("type", store.type());
                    tag.put("total", total);
                    tag.put("used", used);
                    tag.put("avail", avail);
                    tag.put("useRate", (double)used * 100.0 / (double)total);
                    DataPackSender.send(tag);
                    if (!ConfDiskUsage.diskusage_debug_enabled) continue;
                    Logger.yellow(tag.toString());
                }
                catch (Throwable t) {
                    Logger.println("disk_usage", id + " " + t);
                }
            }
        }
        catch (Throwable tt) {
            Logger.println("disk_usage", tt.toString());
        }
    }

    static {
        field = null;
    }
}

