/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.counter.ICounterTask;
import whatap.agent.data.DataPackSender;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.TagCountPack;
import whatap.util.CastUtil;
import whatap.util.CompareUtil;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class ResWasThreadPool
implements ICounterTask {
    Configure conf = Configure.getInstance();
    String old_name;
    public static MBeanServer mserver = null;
    Set<ObjectName> objNameSet;
    private boolean err;

    public ResWasThreadPool() {
        this.old_name = this.conf.jmx_threadpool_objectname;
        this.objNameSet = null;
        this.err = false;
        ConfObserver.add(ResWasThreadPool.class.getName(), new Runnable(){

            public void run() {
                if (!CompareUtil.equals(ResWasThreadPool.this.old_name, ResWasThreadPool.this.conf.jmx_threadpool_objectname)) {
                    ResWasThreadPool.this.objNameSet = null;
                }
                ResWasThreadPool.this.old_name = ResWasThreadPool.this.conf.jmx_threadpool_objectname;
            }
        });
    }

    public void process(CounterPack1 p) {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        if (!this.conf.jmx_threadpool_enabled && !this.err) {
            return;
        }
        if (mserver == null) {
            try {
                mserver = ManagementFactory.getPlatformMBeanServer();
            }
            catch (Throwable t) {
                this.err = true;
                Logger.println(this.getClass().getName(), t);
            }
        }
        try {
            if (this.objNameSet == null) {
                Set<ObjectName> objSet = mserver.queryNames(null, new ObjectName(this.conf.jmx_threadpool_objectname));
                if (objSet != null && objSet.size() > 0) {
                    this.objNameSet = objSet;
                    Logger.println("ThreadPool Object:" + this.objNameSet);
                }
                if (this.objNameSet == null) {
                    return;
                }
            }
            for (ObjectName oname : this.objNameSet) {
                try {
                    Object active = mserver.getAttribute(oname, this.conf.jmx_threadpool_atter_activecount);
                    Object queue = mserver.getAttribute(oname, this.conf.jmx_threadpool_atter_queuesize);
                    int i_active = CastUtil.cint(active);
                    int i_queue = CastUtil.cint(queue);
                    p.threadpool_activeCount += i_active;
                    p.threadpool_queueSize += i_queue;
                    if (!this.conf.jmx_threadpool_detail_enabled) continue;
                    this.poolDetail(p.time, oname.getCanonicalName(), i_active, i_queue);
                }
                catch (Exception e) {
                    Logger.println("ThreadPool Object: " + oname.getCanonicalName() + " " + e);
                }
            }
        }
        catch (Exception e) {
            Logger.println("ThreadPool Object: " + e);
        }
    }

    public void poolDetail(long time, String classId, int act, int que) {
        TagCountPack pk = new TagCountPack();
        pk.category = "thread_pool_detail";
        pk.time = time;
        if (StringUtil.isNotEmpty(this.conf.OKIND_NAME)) {
            pk.putTag("okind", this.conf.OKIND_NAME);
        }
        if (StringUtil.isNotEmpty(this.conf.ONODE_NAME)) {
            pk.putTag("onode", this.conf.ONODE_NAME);
        }
        pk.putTag("oname", SecurityMaster.getInstance().ONAME);
        pk.putTag("pool", classId);
        pk.put("active", act);
        pk.put("queue", que);
        DataPackSender.send(pk);
    }
}

