/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.counter.ICounterTask;
import whatap.lang.pack.CounterPack1;
import whatap.util.CastUtil;
import whatap.util.SystemUtil;

public class ResProcFD
implements ICounterTask {
    public MBeanServer mserver;
    ObjectName obj;
    int err = 0;
    Configure conf = Configure.getInstance();

    public void process(CounterPack1 p) {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        if (this.err >= 5 || !this.conf.counter_procfd_enabled) {
            return;
        }
        try {
            this.mserver = ManagementFactory.getPlatformMBeanServer();
            if (this.obj == null) {
                this.obj = new ObjectName("java.lang:type=OperatingSystem");
            }
            if (this.obj == null) {
                ++this.err;
                Logger.println("JavaOsJmxErr", "not found java.lang:type=OperatingSystem");
                return;
            }
            p.proc_fd = CastUtil.cint(this.mserver.getAttribute(this.obj, "OpenFileDescriptorCount"));
            p.proc_fd_max = CastUtil.cint(this.mserver.getAttribute(this.obj, "MaxFileDescriptorCount"));
            this.err = 0;
        }
        catch (Exception e) {
            Logger.println("JavaOsJmxErr", e.getMessage() + " fail=" + this.err);
            ++this.err;
        }
    }
}

