/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.io.File;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.task.AgentInfo;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.ParamPack;
import whatap.lang.pack.TagCountPack;
import whatap.util.DateUtil;
import whatap.util.FileUtil;

public class MeteringInfo
implements ICounterTask {
    private static Configure conf = Configure.getInstance();
    private ParamPack info = AgentInfo.info;
    private static final String hostUUIDFileName = "/sys/class/dmi/id/product_uuid";
    private boolean first_connected = true;
    private long lastTime = DateUtil.getFiveMinUnit(DateUtil.currentTime());
    private String hostUUID;
    private String csp;
    private static int findAttempts = 10;
    private static int readAttempts = 10;

    public void process(CounterPack1 p) {
        if (!MeteringInfo.conf.metering_tagcount_enabled) {
            return;
        }
        if (this.first_connected) {
            this.first_connected = false;
            this.doProcess(p);
            return;
        }
        long now = DateUtil.getFiveMinUnit(DateUtil.currentTime());
        if (this.lastTime >= now) {
            return;
        }
        this.lastTime = now;
        this.doProcess(p);
    }

    public void doProcess(CounterPack1 p) {
        String host_uuid = this.getHostUUID(hostUUIDFileName);
        if (host_uuid == null) {
            return;
        }
        if (host_uuid.length() == 0) {
            return;
        }
        TagCountPack pk = new TagCountPack();
        pk.category = "metering";
        pk.time = DateUtil.now() / 300000L * 300000L;
        pk.putTag("otype", 1L);
        pk.putTag("subtype", 1L);
        pk.putTag("ip", p.host_ip);
        pk.putTag("_no_5m_hour_", "");
        pk.putTag("host_uuid", host_uuid);
        String csp = this.getCsp();
        if (csp != null) {
            pk.putTag("csp", csp);
        }
        pk.put("mcore", p.metering);
        DataPackSender.send(pk);
        if (MeteringInfo.conf.debug_metering_tagcount_enabled) {
            Logger.println("metering", pk.toString());
        }
    }

    private String getHostUUID(String fileName) {
        try {
            String hostUUID = this.getHostUUIDValue();
            if (hostUUID != null) {
                return hostUUID;
            }
            File file = new File(fileName);
            if (!file.exists()) {
                if (findAttempts-- > 0) {
                    Logger.println("metering", "cannot find " + fileName);
                }
                return null;
            }
            if (!file.canRead()) {
                if (readAttempts-- > 0) {
                    Logger.println("metering", "cannot read " + fileName);
                }
                return null;
            }
            byte[] b = FileUtil.readAll(file);
            if (b != null && b.length > 0) {
                hostUUID = new String(b);
            } else {
                Logger.println("metering", "failed to read " + fileName);
            }
            if (hostUUID != null) {
                this.hostUUID = hostUUID.trim();
                return this.hostUUID;
            }
        }
        catch (Throwable t) {
            Logger.println("metering", 10, t);
        }
        return null;
    }

    public String getHostUUIDValue() {
        return this.hostUUID;
    }

    private String getCsp() {
        String csp;
        if (this.info == null) {
            this.info = AgentInfo.info;
        }
        if (this.info != null && (csp = this.info.getText("CLOUD_PLATFORM")) != null) {
            this.csp = csp;
            return this.csp;
        }
        return null;
    }
}

