/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.io.File;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.app.AppCtxStatCollector;
import whatap.agent.boot.AgentProperty;
import whatap.agent.boot.CloudPlatformHelper;
import whatap.agent.boot.ComponentsVersions;
import whatap.agent.conf.ConfAgentTags;
import whatap.agent.conf.ConfDiagnosis;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.conf.ConfVersion;
import whatap.agent.counter.ICounterTask;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.net.TcpSession;
import whatap.agent.pii.PiiMask;
import whatap.agent.tags.AgentMetaTags;
import whatap.agent.tools.KubeUtil;
import whatap.agent.trace.Alert;
import whatap.agent.trace.urlnorm.RebuildUrlNormScheduler;
import whatap.diagnosis.DiagnosisAgent;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.EventPack;
import whatap.lang.pack.ParamPack;
import whatap.lang.step.HttpcStepX;
import whatap.logsink.workspace.LogSinkAgentProperty;
import whatap.util.AnsiPrint;
import whatap.util.SysJMX;

public class AgentInfo
implements ICounterTask {
    public static ParamPack info;
    public long nextTime = System.currentTimeMillis() + 300000L;
    private static boolean first_connected;
    private long last_name_sent = 0L;
    private int pid = SysJMX.getProcessPID();
    File file = null;
    public static String oom_message;
    public static String oom_thread;
    static boolean set_exception_handler;
    static Thread.UncaughtExceptionHandler orgin_default_handler;

    public void process(CounterPack1 p) {
        PiiMask.update();
        if (oom_message != null) {
            Logger.red("Warning OOM: " + oom_thread + " " + oom_message);
            Alert.oom_error(oom_thread, oom_message);
            oom_message = null;
            oom_thread = null;
        }
        AppCtxStatCollector.update();
        ComponentsVersions.search();
        RebuildUrlNormScheduler.checkBuildScanOrReset();
        p.starttime = SysJMX.getStartTime();
        long now = System.currentTimeMillis();
        if (now > this.nextTime) {
            this.nextTime = now + 3600000L;
            if (ConfAgentTags.kic_enabled && !CloudPlatformHelper.HAS_CHECKED) {
                CloudPlatformHelper.update(info);
            }
            DataPackSender.sendBoot(info);
            ComponentsVersions.send();
        }
        if (TcpSession.last_connected_time > 0L && now > TcpSession.last_connected_time + 5000L) {
            if (first_connected) {
                first_connected = false;
                DataTextAgent.getInstance().reset();
            }
            DataTextAgent.sendMethodAfterBoot();
        }
        this.sendName(now);
        p.containerKey = KubeUtil.container_key;
        this.checkAutoScaleIn();
        HttpcStepX.VERSION = ConfVersion.trace_httpc_version == 1 ? (byte)1 : (byte)2;
        AgentMetaTags.sendTags();
        try {
            AgentInfo.attachOOMAlert();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ConfDiagnosis.diagnosis_enabled) {
            DiagnosisAgent.getInstasnce();
        }
        AgentProperty.send();
        LogSinkAgentProperty.send();
    }

    private void sendName(long now) {
        if (now - this.last_name_sent < 300000L) {
            return;
        }
        this.last_name_sent = now;
        SecurityMaster sm = SecurityMaster.getInstance();
        if (sm.ONAME != null) {
            DataTextAgent.getInstance().add((byte)13, sm.OID, sm.ONAME);
        }
        Configure conf = Configure.getInstance();
        if (conf.OKIND != 0) {
            DataTextAgent.getInstance().add((byte)57, conf.OKIND, conf.OKIND_NAME);
        }
        if (conf.ONODE != 0) {
            DataTextAgent.getInstance().add((byte)63, conf.ONODE, conf.ONODE_NAME);
        }
        if (KubeUtil.container_key != 0) {
            DataTextAgent.getInstance().add((byte)60, KubeUtil.container_key, KubeUtil.container_id);
        }
        if (ConfMTrace.mtrace_spec != null && ConfMTrace.mtrace_spec.length() > 0) {
            DataTextAgent.getInstance().add((byte)53, ConfMTrace.mtrace_spec_hash, ConfMTrace.mtrace_spec);
        }
    }

    private void checkAutoScaleIn() {
        if (this.file == null) {
            String home = System.getProperty("whatap.home", ".");
            this.file = new File(home, "whatap_" + this.pid + ".shutdown");
            Logger.println(AnsiPrint.green("start shutdown-check: dir=[" + home + "] file=[whatap_" + this.pid + ".shutdown]"));
        }
        if (this.file.exists()) {
            Logger.println(AnsiPrint.red("silent-shutdown-event: " + this.file.getAbsolutePath()));
            EventPack e = new EventPack();
            e.title = "SILENT_SHUTDOWN";
            e.level = (byte)10;
            e.status = 1;
            DataPackSender.send(e);
            this.file.delete();
        }
    }

    static void attachOOMAlert() {
        Thread.UncaughtExceptionHandler origin;
        if (!ConfSysMon.event_oom_enabled) {
            if (set_exception_handler) {
                Thread.setDefaultUncaughtExceptionHandler(orgin_default_handler);
                orgin_default_handler = null;
                set_exception_handler = false;
            }
            return;
        }
        if (set_exception_handler) {
            return;
        }
        set_exception_handler = true;
        orgin_default_handler = origin = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                try {
                    if (e instanceof OutOfMemoryError) {
                        oom_thread = t.getName();
                        oom_message = e.getMessage();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (origin != null) {
                    origin.uncaughtException(t, e);
                }
            }
        });
        Logger.yellow("Thread.setDefaultUncaughtExceptionHandler origin=" + (origin == null ? "null" : origin.getClass().getName()));
    }

    static {
        first_connected = true;
        set_exception_handler = false;
    }
}

