/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfActiveStack;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.ActiveStackPack1;
import whatap.util.CompareUtil;
import whatap.util.DateUtil;
import whatap.util.KeyGen;
import whatap.util.LongLinkedSet;
import whatap.util.StrMatch;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class AsyncStackDump
extends Thread {
    private static AsyncStackDump instance = null;
    String match = null;
    public int pooledThreadCount;
    public int activeThreadCount;
    Configure conf = Configure.getInstance();
    LongLinkedSet target = new LongLinkedSet().setMax(2000);
    LongLinkedSet not_target = new LongLinkedSet().setMax(2000);

    public static final synchronized AsyncStackDump getInstance() {
        if (instance == null) {
            instance = new AsyncStackDump();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    public void run() {
        while (SysJMX.getUptime() < 5000L) {
            ThreadUtil.sleep(1000L);
        }
        this.match = ConfActiveStack.async_thread_match;
        ConfObserver.add("AsyncStackDump", new Runnable(){

            public void run() {
                try {
                    if (!CompareUtil.equals(AsyncStackDump.this.match, ConfActiveStack.async_thread_match)) {
                        AsyncStackDump.this.target.clear();
                        AsyncStackDump.this.not_target.clear();
                        AsyncStackDump.this.match = ConfActiveStack.async_thread_match;
                    }
                }
                catch (Throwable e) {
                    Logger.println("AsyncStack1", e.getMessage());
                }
            }
        });
        while (true) {
            int interval = Math.max(2, ConfActiveStack.async_stack_second);
            ThreadUtil.sleep(interval * 1000);
            try {
                if (!ConfActiveStack.async_stack_enabled) continue;
                this.process();
                continue;
            }
            catch (Throwable t) {
                Logger.println("AsyncStack2", t.getMessage());
                continue;
            }
            break;
        }
    }

    public void process() {
        long[] thread;
        StrMatch[] matchList = ConfActiveStack._async_thread_match_set;
        if (matchList.length == 0) {
            return;
        }
        int pooled_count = 0;
        int active_count = 0;
        ArrayList<AbstractPack> packs = null;
        if (ConfActiveStack.active_stack_zip_enabled) {
            packs = new ArrayList<AbstractPack>(40);
        }
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        block4: for (long threadId : thread = tmb.getAllThreadIds()) {
            if (this.not_target.contains(threadId)) continue;
            ThreadInfo f = tmb.getThreadInfo(threadId, ConfActiveStack.async_callstack_depth);
            if (f == null) {
                this.not_target.put(threadId);
                continue;
            }
            String currentThreadName = f.getThreadName();
            if (!this.target.contains(threadId)) {
                if (currentThreadName != null && this.isOk(currentThreadName, matchList)) {
                    this.target.put(threadId);
                } else {
                    this.not_target.put(threadId);
                    continue;
                }
            }
            ++pooled_count;
            StackTraceElement[] se = f.getStackTrace();
            if (ConfActiveStack.isEmptyOrParking(se)) continue;
            if (++active_count < ConfActiveStack.async_stack_count) {
                int i;
                ActiveStackPack1 actStack = new ActiveStackPack1();
                actStack.time = DateUtil.currentTime();
                actStack.activeStackId = KeyGen.next();
                actStack.txid = 0L;
                actStack.service = 0;
                int max = Math.min(se.length, ConfActiveStack.async_callstack_depth);
                if (!ConfActiveStack.async_stack_thread_name_enabled) {
                    actStack.callstack = new int[max];
                    for (i = 0; i < max; ++i) {
                        actStack.callstack[i] = se[i].hashCode();
                        actStack.callstack_hash ^= actStack.callstack[i];
                        DataTextAgent.STACK.add(actStack.callstack[i], se[i]);
                    }
                } else {
                    actStack.callstack = new int[max + 1];
                    for (i = 0; i < max; ++i) {
                        actStack.callstack[i] = se[i].hashCode();
                        actStack.callstack_hash ^= actStack.callstack[i];
                        DataTextAgent.STACK.add(actStack.callstack[i], se[i]);
                    }
                    actStack.callstack[max] = currentThreadName.hashCode();
                    actStack.callstack_hash ^= actStack.callstack[max];
                    DataTextAgent.STACK.add(actStack.callstack[max], f.getThreadName());
                }
                if (packs != null) {
                    packs.add(DataPackSender.setInfo(actStack));
                    if (packs.size() >= 30) {
                        DataPackSender.sendActiveStackZip(packs);
                        packs = new ArrayList(40);
                    }
                } else {
                    DataPackSender.send(actStack, active_count % 100 == 0);
                }
            }
            if (packs == null) continue;
            switch (packs.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    DataPackSender.send((ActiveStackPack1)packs.get(0), false);
                    continue block4;
                }
                default: {
                    DataPackSender.sendActiveStackZip(packs);
                }
            }
        }
        this.pooledThreadCount = pooled_count;
        this.activeThreadCount = active_count;
    }

    private boolean isOk(String tname, StrMatch[] pre) {
        for (StrMatch p : pre) {
            if (!p.include(tname)) continue;
            return true;
        }
        return false;
    }
}

