/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.conf.ConfCollection;
import whatap.agent.counter.collection.COUNT;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntList;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionHolder {
    static IntKeyLinkedMap<WeakReference<Object>> nonstaticHolder = new IntKeyLinkedMap().setMax(1000);

    public static void regist(Object holder) {
        nonstaticHolder.put(System.identityHashCode(holder), new WeakReference<Object>(holder));
    }

    public static void gc() {
        if (nonstaticHolder.size() == 0) {
            return;
        }
        try {
            IntList out = new IntList();
            IntEnumer en = nonstaticHolder.keys();
            while (en.hasMoreElements()) {
                int key = en.nextInt();
                WeakReference<Object> w = nonstaticHolder.get(key);
                if (w.get() != null) continue;
                out.add(key);
            }
            for (int i = 0; i < out.size(); ++i) {
                nonstaticHolder.remove(out.get(i));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MapValue getList(String filter) {
        StringLinkedSet staticNameSet;
        COUNT c;
        StringKeyLinkedMap<COUNT> ent = new StringKeyLinkedMap<COUNT>(){

            @Override
            protected COUNT create(String key) {
                return new COUNT();
            }
        };
        if (ConfCollection.debug_collection_read) {
            Logger.println("DEBUG", "collection: nonstaticHolder.size()=" + nonstaticHolder.size());
        }
        boolean hasFilter = StringUtil.isNotEmpty(filter);
        IntEnumer en = nonstaticHolder.keys();
        while (en.hasMoreElements()) {
            Object o;
            int key = en.nextInt();
            WeakReference<Object> w = nonstaticHolder.get(key);
            if (w == null || (o = w.get()) == null) continue;
            Class<?> target = o.getClass();
            if (hasFilter && target.getName().indexOf(filter) < 0) continue;
            if (ConfCollection.debug_collection_read) {
                Logger.println("DEBUG", "collection: " + target.getName());
            }
            if ((c = CollectionHolder.read(target, o)).getInitCount() <= 0 && !ConfCollection.collection_zero_size_included) continue;
            if (o != null) {
                c.objCount = 1;
            }
            ((COUNT)ent.intern(target.getName())).merge(c);
        }
        String conf = ConfCollection.collection_static_holders;
        if (StringUtil.isNotEmpty(conf) && (staticNameSet = new StringLinkedSet().putAll(StringUtil.tokenizer(conf, ", "))).size() > 0) {
            try {
                Class[] classes = JavaAgent.instrumentation.getAllLoadedClasses();
                for (int i = 0; i < classes.length; ++i) {
                    if (!staticNameSet.contains(classes[i].getName()) || hasFilter && classes[i].getName().indexOf(filter) < 0 || (c = CollectionHolder.read(classes[i], null)).getInitCount() <= 0) continue;
                    c.objCount = 1;
                    ((COUNT)ent.intern(classes[i].getName())).merge(c);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return CollectionHolder.toMapValue(ent);
    }

    private static MapValue toMapValue(StringKeyLinkedMap<COUNT> ent) {
        ent.sort(new Comparator<StringKeyLinkedMap.StringKeyLinkedEntry<COUNT>>(){

            @Override
            public int compare(StringKeyLinkedMap.StringKeyLinkedEntry<COUNT> o1, StringKeyLinkedMap.StringKeyLinkedEntry<COUNT> o2) {
                int c1 = o2.getValue().size() - o1.getValue().size();
                if (c1 != 0) {
                    return c1;
                }
                return CompareUtil.compareTo(o1.getKey(), o2.getKey());
            }
        });
        MapValue out = new MapValue();
        ListValue holderLv = out.newList("holder");
        ListValue countLv = out.newList("inst");
        ListValue mapInstLv = out.newList("mapInst");
        ListValue mapElemLv = out.newList("mapElem");
        ListValue lstInstLv = out.newList("listInst");
        ListValue lstElemLv = out.newList("listElem");
        ListValue setInstLv = out.newList("setInst");
        ListValue setElemLv = out.newList("setElem");
        StringEnumer en = ent.keys();
        for (int x = 0; x < ConfCollection.collection_holder_read_max && en.hasMoreElements(); ++x) {
            String holder = en.nextString();
            COUNT c = ent.get(holder);
            holderLv.add(holder);
            countLv.add(c.objCount);
            mapInstLv.add(c.mapInstance);
            mapElemLv.add(c.mapElements);
            lstInstLv.add(c.listInstance);
            lstElemLv.add(c.listElements);
            setInstLv.add(c.setInstance);
            setElemLv.add(c.setElements);
        }
        return out;
    }

    private static COUNT read(Class class1, Object o) {
        COUNT c = new COUNT();
        try {
            while (class1 != Object.class) {
                CollectionHolder.read(class1, o, c);
                class1 = class1.getSuperclass();
            }
        }
        catch (Throwable t) {
            Logger.red(class1.getName() + " " + t.getMessage());
        }
        return c;
    }

    private static void read(Class class1, Object o, COUNT c) {
        Field[] m = class1.getDeclaredFields();
        for (int i = 0; i < m.length; ++i) {
            Class<?> tc = m[i].getType();
            try {
                if (Map.class.isAssignableFrom(tc)) {
                    m[i].setAccessible(true);
                    Map m1 = (Map)m[i].get(o);
                    if (m1 != null) {
                        c.mapElements += m1.size();
                    }
                    ++c.mapInstance;
                    continue;
                }
                if (List.class.isAssignableFrom(tc)) {
                    m[i].setAccessible(true);
                    List lst1 = (List)m[i].get(o);
                    if (lst1 != null) {
                        c.listElements += lst1.size();
                    }
                    ++c.listInstance;
                    continue;
                }
                if (!Set.class.isAssignableFrom(tc)) continue;
                m[i].setAccessible(true);
                Set set1 = (Set)m[i].get(o);
                if (set1 != null) {
                    c.setElements += set1.size();
                }
                ++c.setInstance;
                continue;
            }
            catch (Exception e) {
                Logger.red(class1.getName() + " " + e.getMessage());
            }
        }
    }
}

