/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter;

import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.counter.CountCollector;
import whatap.agent.counter.ICounterTask;
import whatap.lang.pack.CounterPack1;
import whatap.util.StringKeyLinkedMap;

public class CounterTaskExtendedRegistry
implements ICounterTask {
    private static volatile CounterTaskExtendedRegistry instance;
    private static final StringKeyLinkedMap<ICounterTask> tasks;
    private volatile boolean registeredToCollector = false;

    private CounterTaskExtendedRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CounterTaskExtendedRegistry getInstance() {
        if (instance != null) return instance;
        Class<CounterTaskExtendedRegistry> clazz = CounterTaskExtendedRegistry.class;
        synchronized (CounterTaskExtendedRegistry.class) {
            if (instance != null) return instance;
            instance = new CounterTaskExtendedRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerTask(String id, ICounterTask task) {
        if (id == null || task == null) {
            Logger.println("CounterTaskExtendedRegistry", "Invalid registration: id=" + id + ", task=" + task);
            return;
        }
        this.ensureRegisteredToCollector();
        ICounterTask existing = tasks.put(id, task);
        if (existing != null) {
            Logger.println("CounterTaskExtendedRegistry", "Replaced existing task: " + id);
        }
    }

    public void registerTask(ICounterTask task) {
        if (task == null) {
            Logger.println("CounterTaskExtendedRegistry", "Cannot register null task");
            return;
        }
        this.registerTask(task.getClass().getName(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRegisteredToCollector() {
        if (!this.registeredToCollector) {
            CounterTaskExtendedRegistry counterTaskExtendedRegistry = this;
            synchronized (counterTaskExtendedRegistry) {
                if (!this.registeredToCollector) {
                    try {
                        CountCollector.getInstance().registerTask(this);
                        this.registeredToCollector = true;
                    }
                    catch (Throwable t) {
                        Logger.println("CounterTaskExtendedRegistry", "Failed to register to CountCollector", t);
                    }
                }
            }
        }
    }

    public void registerToCollector() {
        this.ensureRegisteredToCollector();
    }

    public boolean isRegistered(String id) {
        return tasks.containsKey(id);
    }

    public int getTaskCount() {
        return tasks.size();
    }

    public ICounterTask unregisterTask(String id) {
        if (id == null) {
            return null;
        }
        ICounterTask removed = tasks.remove(id);
        if (removed != null) {
            Logger.println("CounterTaskExtendedRegistry", "Unregistered task: " + id);
        }
        return removed;
    }

    public void process(CounterPack1 p) {
        if (tasks.isEmpty()) {
            return;
        }
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<ICounterTask>> entries = tasks.entries();
        while (entries.hasMoreElements()) {
            String key = null;
            ICounterTask task = null;
            try {
                StringKeyLinkedMap.StringKeyLinkedEntry<ICounterTask> entry = entries.nextElement();
                if (entry == null) continue;
                key = entry.getKey();
                task = entry.getValue();
                task.process(p);
            }
            catch (Throwable t) {
                Logger.println("CounterTaskExtendedRegistry", 10, "Error processing task: " + key + " - " + t.getMessage());
            }
        }
    }

    static {
        tasks = new StringKeyLinkedMap();
    }
}

