/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.ds;

import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.ListValue;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaXDBConPoolFold {
    static Configure conf = Configure.getInstance();
    static TagCountPack pack;

    public static void prepare(String classId, StringKeyLinkedMap<CNT> pool) {
        if (pack == null) {
            pack = new TagCountPack();
            JavaXDBConPoolFold.pack.category = "javax_dbcon_pool";
            JavaXDBConPoolFold.pack.time = DateUtil.now() / 5000L * 5000L;
            if (StringUtil.isNotEmpty(JavaXDBConPoolFold.conf.OKIND_NAME)) {
                pack.putTag("okindName", JavaXDBConPoolFold.conf.OKIND_NAME);
            }
            if (StringUtil.isNotEmpty(JavaXDBConPoolFold.conf.ONODE_NAME)) {
                pack.putTag("onodeName", JavaXDBConPoolFold.conf.ONODE_NAME);
            }
            pack.putTag("oname", SecurityMaster.getInstance().ONAME);
            JavaXDBConPoolFold.pack.tags.put("!rectype", 2);
        }
        ListValue idLv = JavaXDBConPoolFold.pack.fields.internList("@id");
        ListValue poolLv = JavaXDBConPoolFold.pack.fields.internList("pool");
        ListValue classLv = JavaXDBConPoolFold.pack.fields.internList("class");
        ListValue actLv = JavaXDBConPoolFold.pack.fields.internList("act");
        ListValue idleLv = JavaXDBConPoolFold.pack.fields.internList("idle");
        ListValue totLv = JavaXDBConPoolFold.pack.fields.internList("tot");
        StringEnumer en = pool.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            CNT cnt = pool.get(key);
            idLv.add(HashUtil.hash(key));
            poolLv.add(key);
            classLv.add(classId);
            actLv.add(cnt.act);
            idleLv.add(cnt.idle);
            totLv.add(cnt.act + cnt.idle);
        }
    }

    public static void sendAndReset() {
        if (pack != null) {
            DataPackSender.send(pack);
        }
        pack = null;
    }
}

