/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MBeanServer;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfLog;
import whatap.io.DataInputX;
import whatap.lang.H2;
import whatap.lang.pack.ParamPack;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.SystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentHeapDump {
    private static String fileExt = ".hprof";
    private static long lastCallTime = 0L;

    public static String callHeapDump(ParamPack p) {
        long curTime;
        File hprofDir = new File(ConfLog.heapdump_root);
        if (!hprofDir.exists()) {
            hprofDir.mkdirs();
        }
        if ((curTime = System.currentTimeMillis()) - lastCallTime < 10000L) {
            return "please wait 10 sec. from last request...";
        }
        lastCallTime = curTime;
        String date = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        String fileName = "heapdump-" + SecurityMaster.getInstance().ONAME + "-" + date + fileExt;
        if (SystemUtil.IS_JAVA_1_5) {
            return "dumpHeap only works on a Sun Java 1.6+ VM";
        }
        String error = AgentHeapDump.dumpHeap(new File(hprofDir, fileName));
        return error;
    }

    public static String dumpHeap(File fileName) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
        }
        catch (ClassNotFoundException e) {
            return "dumpHeap only works on a Java 1.6+ VM";
        }
        Object hotspotMBean = null;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
        }
        catch (Throwable e) {
            return "dumpHeap was unable to obtain the HotSpotDiagnosticMXBean: " + e.getMessage();
        }
        try {
            Method method = hotspotMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            method.invoke(hotspotMBean, fileName.getAbsolutePath(), true);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause() != null ? e.getCause() : e;
            return "dumpHeap threw a InvocationTargetException: " + t;
        }
        catch (Throwable e) {
            return "dumpHeap threw a Throwable: " + e;
        }
        return null;
    }

    public static MapValue listHeapDump() {
        MapValue ent = new MapValue();
        ListValue nameLv = ent.newList("name");
        ListValue sizeLv = ent.newList("size");
        File root = new File(System.getProperty("whatap.home", "."), "dump");
        if (!root.exists()) {
            return ent;
        }
        File[] fileList = root.listFiles();
        if (fileList != null && fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                File f = fileList[i];
                if (!f.isFile() || !f.getName().endsWith(fileExt)) continue;
                nameLv.add(f.getName());
                sizeLv.add(f.length());
            }
        }
        return ent;
    }

    public static void downloadHeapDump(String name, H2<Boolean, byte[]> handler) {
        int buff = 0x200000;
        File root = new File(System.getProperty("whatap.home", "."), "dump");
        File downloadFile = new File(root, name);
        try {
            RandomAccessFile raf = new RandomAccessFile(downloadFile, "r");
            byte[] buffer = new byte[buff];
            int read = 0;
            long offset = downloadFile.length();
            while ((long)read < offset) {
                int unitsize = (int)(offset - (long)read >= (long)buff ? (long)buff : offset - (long)read);
                raf.read(buffer, 0, unitsize);
                handler.process(true, buffer.length == unitsize ? buffer : DataInputX.get(buffer, 0, unitsize));
                read += unitsize;
            }
            raf.close();
            handler.process(false, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

