/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import whatap.agent.Configure;
import whatap.util.StringUtil;

public class ConfUser {
    public static boolean wclient_enabled = true;
    public static final int NONE = 0;
    public static final int IP = 1;
    public static final int COOKIE = 2;
    public static final int HEADER = 3;
    public static final int JSESSION = 4;
    public static int trace_user_method = 1;
    public static int wclient_trace_type = 1;
    public static String trace_user_jsession_key = "JSESSIONID";
    public static String wclient_jsession_key = "JSESSIONID";
    public static String trace_user_header_key = "token";
    public static String wclient_header_key = "token";
    public static int trace_user_cookie_limit = 4000;
    public static int wclient_cookie_limit = 4000;
    public static String wclient_cookie_domain = "";
    public static boolean _has_wclient_cookie_domain = false;
    public static boolean _has_user_domain = false;
    public static String trace_user_cookie_domain = "";
    public static String log = null;
    public static long wclient_thinktime_max = 300000L;
    public static long realtime_user_thinktime_max = 300000L;
    public static int wclient_max_count = 70000;

    public static void apply(Configure conf) {
        wclient_enabled = conf.enabled && conf.getBoolean("wclient_enabled", conf.getBoolean("realtime_user_enabled", conf.getBoolean("trace_user_enabled", true)));
        trace_user_jsession_key = wclient_jsession_key = conf.getValue("wclient_jsession_key", conf.getValue("trace_user_jsession_key", "JSESSIONID"));
        trace_user_header_key = wclient_header_key = conf.getValue("wclient_header_key", conf.getValue("trace_user_header_key", "whatap"));
        int old = wclient_trace_type;
        if (!wclient_enabled) {
            wclient_trace_type = 0;
        } else {
            String t = conf.getValue("wclient_trace_type", conf.getValue("trace_user_method", ""));
            if ("ip".equals(t = StringUtil.toLower(t))) {
                wclient_trace_type = 1;
            } else if ("cookie".equals(t)) {
                wclient_trace_type = 2;
            } else if ("header".equals(t)) {
                wclient_trace_type = 3;
            } else if ("jsession".equals(t)) {
                wclient_trace_type = 4;
            } else if ("none".equals(t)) {
                wclient_trace_type = 0;
            } else if (conf.getBoolean("wclient_using_ip", conf.getBoolean("trace_user_using_ip", true))) {
                wclient_trace_type = 1;
            } else {
                String ticket = conf.getValue("wclient_header_ticket", conf.getValue("user_header_ticket", ""));
                if (StringUtil.isNotEmpty(ticket)) {
                    wclient_trace_type = 3;
                    wclient_header_key = ticket;
                } else {
                    wclient_trace_type = 2;
                }
            }
        }
        trace_user_method = wclient_trace_type;
        if (old != wclient_trace_type) {
            log = "wclient_trace_type=" + ConfUser.toString(wclient_trace_type);
        }
        trace_user_cookie_limit = wclient_cookie_limit = conf.getInt("wclient_cookie_limit", conf.getInt("trace_user_cookie_limit", 4000));
        String tmp = conf.getValue("trace_user_cookie_domain", conf.getValue("trace_user_domain", ""));
        wclient_cookie_domain = conf.getValue("wclient_cookie_domain", tmp);
        _has_wclient_cookie_domain = StringUtil.isNotEmpty(wclient_cookie_domain);
        trace_user_cookie_domain = wclient_cookie_domain;
        _has_user_domain = _has_wclient_cookie_domain;
        realtime_user_thinktime_max = wclient_thinktime_max = (long)conf.getInt("wclient_thinktime_max", conf.getInt("realtime_user_thinktime_max", 300000));
        wclient_max_count = conf.getInt("wclient_max_count", 70000);
    }

    private static String toString(int m) {
        switch (m) {
            case 0: {
                return "none";
            }
            case 1: {
                return "ip";
            }
            case 2: {
                return "cookie";
            }
            case 3: {
                return "header";
            }
            case 4: {
                return "jsession";
            }
        }
        return "unknown";
    }
}

