/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import whatap.agent.Configure;
import whatap.agent.counter.task.res.util.LinuxProcStatUtil;
import whatap.util.SystemUtil;

public class ConfSysMon {
    public static boolean aws_ecs_enabled = false;
    public static boolean debug_aws_ecs_enabled = false;
    public static int aws_ecs_stat_interval = 3000;
    public static String aws_ecs_limits_uri_postfix = "/task";
    public static boolean aws_ecs_limits_uri_postfix_enabled = true;
    public static boolean aws_ecs_metadata_uri_recent_enabled = false;
    public static boolean linux_proc_stat_enabled = false;
    public static float correction_factor_cpu = 1.0f;
    public static float correction_factor_pcpu = 1.0f;
    public static boolean sigar_enabled = false;
    public static boolean sigar_disk_enabled = false;
    public static String sigar_disk_path = ".";
    public static long sigar_disk_interval = 300000L;
    public static boolean oshi_enabled = false;
    public static boolean oshi_disk_enabled = true;
    public static String oshi_disk_path = ".";
    public static long oshi_disk_interval = 300000L;
    public static boolean _enable_emb_sigar = true;
    public static int cpu_event_percent = 90;
    public static int cpu_event_duration = 10000;
    public static long cpu_event_interval = 300000L;
    public static boolean cpu_event_enabled = false;
    public static String cpu_event_action = null;
    public static int disk_event_percent = 90;
    public static long disk_event_interval = 3600000L;
    public static boolean disk_event_enabled = false;
    public static String disk_event_action = null;
    public static boolean event_oom_enabled = false;
    public static long oom_event_interval = 30000L;
    public static boolean oshi_network_enabled = false;
    public static String oshi_network_prefix = "";
    public static boolean oshi_proc_mem_enabled = false;
    public static int linux_pagesize = 0;
    public static boolean oshi_proc_cpu_from_sysfile = false;
    public static boolean oshi_plugin_enabled = false;
    public static boolean debug_oshi_plugin_loader = false;
    public static int oshi_plugin_interval = 5000;
    public static int oshi_plugin_load_interval = 10000;
    public static String oshi_plugin_libroot = System.getProperty("whatap.home", ".") + "/oshi";

    public static void apply(Configure conf) {
        sigar_enabled = conf.enabled && conf.getBoolean("sigar_enabled", false);
        sigar_disk_enabled = conf.enabled && conf.getBoolean("sigar_disk_enabled", false);
        _enable_emb_sigar = conf.enabled && conf.getBoolean("_enable_emb_sigar", sigar_enabled);
        sigar_disk_path = conf.getValue("sigar_disk_path", ".");
        sigar_disk_interval = conf.getLong("sigar_disk_interval", 300000L);
        oshi_enabled = conf.enabled && conf.getBoolean("oshi_enabled", false);
        oshi_disk_enabled = conf.enabled && conf.getBoolean("oshi_disk_enabled", true);
        oshi_disk_path = conf.getValue("oshi_disk_path", ".");
        oshi_disk_interval = conf.getLong("oshi_disk_interval", 300000L);
        try {
            String meta_uri = System.getenv("ECS_CONTAINER_METADATA_URI");
            boolean bl = aws_ecs_enabled = meta_uri != null;
            if (aws_ecs_enabled) {
                aws_ecs_enabled = conf.getBoolean("whatap.ecs.enabled", true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        debug_aws_ecs_enabled = conf.getBoolean("debug_aws_ecs_enabled", false);
        aws_ecs_metadata_uri_recent_enabled = conf.getBoolean("aws_ecs_metadata_uri_recent_enabled", false);
        aws_ecs_limits_uri_postfix_enabled = conf.getBoolean("aws_ecs_limits_uri_postfix_enabled", true);
        aws_ecs_limits_uri_postfix = conf.getValue("aws_ecs_limits_uri_postfix", "/task");
        linux_proc_stat_enabled = conf.getBoolean("linux_proc_stat_enabled", false);
        correction_factor_cpu = conf.getFloat("correction_factor_cpu", 1.0f);
        correction_factor_pcpu = conf.getFloat("correction_factor_pcpu", 1.0f);
        aws_ecs_stat_interval = conf.getInt("aws_ecs_stat_interval", 3000);
        if (aws_ecs_stat_interval < 1000) {
            aws_ecs_stat_interval = 1000;
        }
        disk_event_percent = conf.getInt("disk_event_percent", 90);
        disk_event_interval = conf.getLong("disk_event_interval", 3600000L);
        disk_event_enabled = conf.getBoolean("disk_event_enabled", false);
        disk_event_action = conf.getValue("disk_event_action", "");
        cpu_event_percent = conf.getInt("cpu_event_percent", 90);
        cpu_event_duration = conf.getInt("cpu_event_duration", 10000);
        cpu_event_interval = conf.getLong("cpu_event_interval", 300000L);
        cpu_event_enabled = conf.getBoolean("cpu_event_enabled", false);
        cpu_event_action = conf.getValue("cpu_event_action", "");
        oshi_proc_mem_enabled = conf.getBoolean("oshi_proc_mem_enabled", false);
        oshi_network_enabled = conf.getBoolean("oshi_network_enabled", false);
        oshi_network_prefix = conf.getValue("oshi_network_prefix", "");
        oshi_proc_cpu_from_sysfile = conf.getBoolean("oshi_proc_cpu_from_sysfile", false);
        linux_pagesize = conf.getInt("linux_pagesize", 0);
        event_oom_enabled = conf.getBoolean("event_oom_enabled", false);
        oom_event_interval = conf.getLong("oom_event_interval", 30000L);
        oshi_plugin_enabled = conf.getBoolean("oshi_plugin_enabled", false);
        oshi_plugin_libroot = conf.getValue("oshi_plugin_libroot", System.getProperty("whatap.home", ".") + "/oshi");
        debug_oshi_plugin_loader = conf.getBoolean("debug_oshi_plugin_loader", false);
        oshi_plugin_interval = conf.getInt("oshi_plugin_interval", 5000, 2000);
        oshi_plugin_load_interval = conf.getInt("oshi_plugin_load_interval", 10000, 5000);
    }

    public static byte findType() {
        int t = 1;
        t = Configure.getInstance().WHATAP_MICRO_ENABLED ? 3 : (aws_ecs_enabled ? 2 : (linux_proc_stat_enabled ? (SystemUtil.IS_LINUX && LinuxProcStatUtil.isLinux() ? 4 : 5) : (oshi_enabled ? 8 : (sigar_enabled ? 7 : 5))));
        return (byte)t;
    }
}

