/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import whatap.agent.Configure;
import whatap.org.json.JSONObject;

public class ConfLogSink {
    public static boolean watchlog_enabled = false;
    public static long watchlog_check_interval = 2000L;
    public static int watchlog_read_count = 8;
    public static int watchlog_send_count = 1;
    public static int watchlog_buffer_size = 131072;
    public static boolean logsink_enabled;
    public static boolean logsink_stdout_enabled;
    public static boolean logsink_stderr_enabled;
    public static boolean logsink_logback_enabled;
    public static boolean logsink_log4j_enabled;
    public static boolean logsink_tomcat_enabled;
    public static boolean logsink_custom_enabled;
    public static boolean logsink_logapi_enabled;
    public static boolean logsink_logger_util_enabled;
    public static int logsink_pack_queue_size;
    public static int logsink_linelog_queue_size;
    public static int logsink_stdout_queue_size;
    public static boolean debug_logsink_enabled;
    public static boolean debug_logsink_dropped_enabled;
    public static boolean debug_logsink_dropped_detail_enabled;
    public static int logsink_line_size;
    public static int logsink_limit_content_log_silent_time;
    public static int logsink_limit_content_alert_silent_time;
    public static boolean logsink_limit_content_enabled;
    public static boolean logsink_limit_content_alert_enabled;
    public static int logsink_limit_content_length;
    public static boolean debug_logsink_limit_content_enabled;
    public static int debug_logsink_limit_content_length;
    public static boolean logsink_zip_enabled;
    public static int logsink_max_buffer_size;
    public static int logsink_max_wait_time;
    public static int logsink_zip_min_size;
    public static boolean debug_logsink_zip_enabled;
    public static List<String[]> logsink_tags;
    public static boolean _has_logsink_tags_;
    private static String logsink_tags_str;
    public static int logsink_zip_defer_time;
    public static String logsink_category_log4j;
    public static String logsink_category_logback;
    public static String logsink_category_custom;
    public static String logsink_category_stderr;
    public static String logsink_category_stdout;
    public static String logsink_category_tomcat;
    public static boolean logsink_rt_enabled;
    public static boolean logsink_rt_dbc_ok_enabled;
    public static boolean logsink_rt_dbc_error_enabled;
    public static boolean logsink_rt_httpc_ok_enabled;
    public static boolean logsink_rt_httpc_error_enabled;
    public static boolean logsink_rt_socket_enabled;
    public static long logsink_rt_error_interval;
    public static long logsink_rt_ok_interval;
    public static boolean logsink_trace_enabled;
    public static boolean logsink_trace_txid_enabled;
    public static boolean logsink_trace_mtid_enabled;
    public static boolean logsink_trace_custid_enabled;
    public static boolean logsink_trace_login_enabled;
    public static boolean logsink_trace_httphost_enabled;
    public static boolean logsink_high_secure_enabled;
    public static boolean log_append_trace_enabled;

    public static void apply(Configure conf) {
        watchlog_enabled = conf.getBoolean("watchlog_enabled", false);
        watchlog_check_interval = conf.getLong("watchlog_check_interval", 2000L);
        watchlog_read_count = conf.getInt("watchlog_read_count", 4);
        if (watchlog_read_count < 1) {
            watchlog_read_count = 1;
        }
        watchlog_send_count = conf.getInt("watchlog_send_count", 1);
        watchlog_buffer_size = conf.getInt("watchlog_buffer_size", 131072);
        logsink_enabled = conf.getBoolean("logsink_enabled", false);
        logsink_stdout_enabled = conf.getBoolean("logsink_stdout_enabled", logsink_enabled);
        logsink_stderr_enabled = conf.getBoolean("logsink_stderr_enabled", logsink_enabled);
        logsink_logback_enabled = conf.getBoolean("logsink_logback_enabled", logsink_enabled);
        logsink_log4j_enabled = conf.getBoolean("logsink_log4j_enabled", logsink_enabled);
        logsink_tomcat_enabled = conf.getBoolean("logsink_tomcat_enabled", logsink_enabled);
        logsink_custom_enabled = conf.getBoolean("logsink_custom_enabled", logsink_enabled);
        logsink_logapi_enabled = conf.getBoolean("logsink_logapi_enabled", logsink_enabled);
        logsink_logger_util_enabled = conf.getBoolean("logsink_logger_util_enabled", false);
        logsink_pack_queue_size = conf.getInt("logsink_pack_queue_size", 1000);
        logsink_linelog_queue_size = conf.getInt("logsink_linelog_queue_size", 1000);
        logsink_stdout_queue_size = conf.getInt("logsink_stdout_queue_size", 1000);
        logsink_line_size = conf.getInt("logsink_line_size", 512);
        logsink_limit_content_enabled = conf.getBoolean("logsink_limit_content_enabled", false);
        logsink_limit_content_log_silent_time = conf.getInt("logsink_limit_content_log_silent_time", 1000);
        logsink_limit_content_alert_silent_time = conf.getInt("logsink_limit_content_alert_silent_time", 10000);
        logsink_limit_content_alert_enabled = conf.getBoolean("logsink_limit_content_alert_enabled", false);
        logsink_limit_content_length = conf.getInt("logsink_limit_content_length", 1000000);
        debug_logsink_limit_content_enabled = conf.getBoolean("debug_logsink_limit_content_enabled", true);
        debug_logsink_enabled = conf.getBoolean("debug_logsink_enabled", false);
        debug_logsink_dropped_enabled = conf.getBoolean("debug_logsink_dropped_enabled", false);
        debug_logsink_dropped_detail_enabled = conf.getBoolean("debug_logsink_dropped_detail_enabled", false);
        debug_logsink_limit_content_length = conf.getInt("debug_logsink_limit_content_length", 0);
        logsink_zip_enabled = logsink_enabled && conf.getBoolean("logsink_zip_enabled", true);
        logsink_max_buffer_size = conf.getInt("logsink_max_buffer_size", 65536);
        logsink_max_wait_time = conf.getInt("logsink_max_wait_time", 2000);
        logsink_zip_min_size = conf.getInt("logsink_zip_min_size", 100);
        debug_logsink_zip_enabled = conf.getBoolean("debug_logsink_zip_enabled", false);
        logsink_zip_defer_time = conf.getInt("logsink_zip_defer_time", 30000);
        logsink_category_log4j = conf.getValue("logsink_category_log4j", "AppLog");
        logsink_category_logback = conf.getValue("logsink_category_logback", "AppLog");
        logsink_category_custom = conf.getValue("logsink_category_custom", "AppLog");
        logsink_category_stdout = conf.getValue("logsink_category_stdout", "AppStdOut");
        logsink_category_stderr = conf.getValue("logsink_category_stderr", "AppStdErr");
        logsink_category_tomcat = conf.getValue("logsink_category_tomcat", "AppServer");
        ConfLogSink.parseLogSinkTags(conf);
        logsink_rt_enabled = logsink_enabled && conf.getBoolean("logsink_rt_enabled", false);
        logsink_rt_dbc_ok_enabled = logsink_enabled && conf.getBoolean("logsink_rt_dbc_ok_enabled", logsink_rt_enabled);
        logsink_rt_dbc_error_enabled = logsink_enabled && conf.getBoolean("logsink_rt_dbc_error_enabled", logsink_rt_enabled);
        logsink_rt_httpc_ok_enabled = logsink_enabled && conf.getBoolean("logsink_rt_httpc_ok_enabled", logsink_rt_enabled);
        logsink_rt_httpc_error_enabled = logsink_enabled && conf.getBoolean("logsink_rt_httpc_error_enabled", logsink_rt_enabled);
        logsink_rt_socket_enabled = logsink_enabled && conf.getBoolean("logsink_rt_socket_enabled", logsink_rt_enabled);
        logsink_rt_error_interval = conf.getLong("logsink_rt_error_interval", 5000L);
        logsink_rt_ok_interval = conf.getLong("logsink_rt_ok_interval", 30000L);
        logsink_trace_txid_enabled = conf.getBoolean("logsink_trace_txid_enabled", true);
        logsink_trace_mtid_enabled = conf.getBoolean("logsink_trace_mtid_enabled", true);
        logsink_trace_custid_enabled = conf.getBoolean("logsink_trace_custid_enabled", true);
        logsink_trace_login_enabled = conf.getBoolean("logsink_trace_login_enabled", false);
        logsink_trace_httphost_enabled = conf.getBoolean("logsink_trace_httphost_enabled", false);
        logsink_trace_enabled = conf.getBoolean("logtag_txid_enabled", false) ? conf.getBoolean("logsink_trace_enabled", true) : conf.getBoolean("logsink_trace_enabled", false);
        logsink_trace_enabled = conf.getBoolean("logtag_mtid_enabled", false) ? conf.getBoolean("logsink_trace_enabled", true) : conf.getBoolean("logsink_trace_enabled", false);
        logsink_high_secure_enabled = conf.getBoolean("logsink_high_secure_enabled", false);
        log_append_trace_enabled = conf.getBoolean("log_append_trace_enabled", false);
    }

    private static void parseLogSinkTags(Configure conf) {
        String tags = conf.getValue("logsink_tags");
        if (tags == null || tags.length() == 0) {
            _has_logsink_tags_ = false;
            logsink_tags_str = "";
            if (logsink_tags.size() > 0) {
                logsink_tags = new ArrayList<String[]>();
            }
            return;
        }
        if (tags.equals(logsink_tags_str)) {
            return;
        }
        logsink_tags_str = tags;
        ArrayList<String[]> out = new ArrayList<String[]>();
        try {
            JSONObject obj = new JSONObject(logsink_tags_str);
            Iterator<String> itr = obj.keys();
            while (itr.hasNext()) {
                String key = itr.next();
                Object value = obj.opt(key);
                if (value == null) continue;
                out.add(new String[]{key, value.toString()});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logsink_tags = out;
        _has_logsink_tags_ = out.size() > 0;
    }

    static {
        logsink_stdout_enabled = logsink_enabled = false;
        logsink_stderr_enabled = logsink_enabled;
        logsink_logback_enabled = logsink_enabled;
        logsink_log4j_enabled = logsink_enabled;
        logsink_tomcat_enabled = logsink_enabled;
        logsink_custom_enabled = logsink_enabled;
        logsink_logapi_enabled = logsink_enabled;
        logsink_logger_util_enabled = false;
        logsink_pack_queue_size = 1000;
        logsink_linelog_queue_size = 1000;
        logsink_stdout_queue_size = 1000;
        debug_logsink_enabled = false;
        debug_logsink_dropped_enabled = false;
        debug_logsink_dropped_detail_enabled = false;
        logsink_line_size = 512;
        logsink_limit_content_log_silent_time = 1000;
        logsink_limit_content_alert_silent_time = 10000;
        logsink_limit_content_enabled = false;
        logsink_limit_content_alert_enabled = false;
        logsink_limit_content_length = 1000000;
        debug_logsink_limit_content_enabled = true;
        debug_logsink_limit_content_length = 0;
        logsink_zip_enabled = true;
        logsink_max_buffer_size = 65536;
        logsink_max_wait_time = 2000;
        logsink_zip_min_size = 100;
        logsink_tags = new ArrayList<String[]>();
        _has_logsink_tags_ = false;
        logsink_tags_str = "";
        logsink_zip_defer_time = 30000;
        logsink_category_log4j = "AppLog";
        logsink_category_logback = "AppLog";
        logsink_category_custom = "AppLog";
        logsink_category_stderr = "AppStdErr";
        logsink_category_stdout = "AppStdOut";
        logsink_category_tomcat = "AppServer";
        logsink_rt_dbc_ok_enabled = logsink_rt_enabled = false;
        logsink_rt_dbc_error_enabled = logsink_rt_enabled;
        logsink_rt_httpc_ok_enabled = logsink_rt_enabled;
        logsink_rt_httpc_error_enabled = logsink_rt_enabled;
        logsink_rt_socket_enabled = logsink_rt_enabled;
        logsink_rt_error_interval = 5000L;
        logsink_rt_ok_interval = 30000L;
        logsink_trace_enabled = false;
        logsink_trace_txid_enabled = true;
        logsink_trace_mtid_enabled = true;
        logsink_trace_custid_enabled = true;
        logsink_trace_login_enabled = false;
        logsink_trace_httphost_enabled = false;
        logsink_high_secure_enabled = false;
        log_append_trace_enabled = false;
    }
}

