/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import whatap.agent.Configure;

public class ConfInstrumentation {
    public static boolean instrumentation_rmi_enabled = false;
    public static boolean instrumentation_rmi_capture_param_enabled = false;
    public static boolean debug_instrumentation_rmi_enabled = false;
    public static boolean instrumentation_executor_enabled = false;
    public static boolean instrumentation_executor_threadpool_enabled = true;
    public static boolean instrumentation_executor_scheduled_enabled = true;
    public static boolean instrumentation_executor_forkjoin_enabled = true;
    public static boolean debug_instrumentation_executor_enabled = false;
    public static String instrumentation_executor_exclude_classes = "";
    private static final String[] DEFAULT_EXCLUDE_TASK_PREFIXES = new String[]{"java.util.concurrent.ForkJoinTask", "java.util.TimerTask", "sun.rmi.", "io.netty.", "io.grpc.netty.shaded.io.netty.", "org.apache.tomcat.", "org.eclipse.jetty.", "io.undertow.", "org.apache.kafka.", "okhttp3.", "com.squareup.okhttp.", "io.prestosql.jdbc.$internal.okhttp3.", "io.trino.jdbc.$internal.okhttp3.", "reactor.core.", "io.reactivex.", "akka.", "org.apache.pekko.", "org.springframework.amqp.rabbit.listener.", "org.springframework.util.ConcurrentLruCache$", "org.springframework.scheduling.", "com.mysql.", "io.nats.", "org.hornetq.", "org.quartz.", "ratpack.exec.internal.", "zio.internal.", "org.graalvm."};
    static final String DEFAULT_EXCLUDE_TASK_PREFIXES_STR;
    public static String instrumentation_executor_exclude_task_prefixes;

    public static void apply(Configure conf) {
        instrumentation_rmi_enabled = conf.getBoolean("instrumentation_rmi_enabled", false);
        instrumentation_rmi_capture_param_enabled = conf.getBoolean("instrumentation_rmi_capture_param_enabled", false);
        debug_instrumentation_rmi_enabled = conf.getBoolean("debug_instrumentation_rmi_enabled", false);
        instrumentation_executor_enabled = conf.getBoolean("instrumentation_executor_enabled", false);
        instrumentation_executor_threadpool_enabled = conf.getBoolean("instrumentation_executor_threadpool_enabled", true);
        instrumentation_executor_scheduled_enabled = conf.getBoolean("instrumentation_executor_scheduled_enabled", true);
        instrumentation_executor_forkjoin_enabled = conf.getBoolean("instrumentation_executor_forkjoin_enabled", true);
        debug_instrumentation_executor_enabled = conf.getBoolean("debug_instrumentation_executor_enabled", false);
        instrumentation_executor_exclude_classes = conf.getValue("instrumentation_executor_exclude_classes", "");
        instrumentation_executor_exclude_task_prefixes = conf.getValue("instrumentation_executor_exclude_task_prefixes", DEFAULT_EXCLUDE_TASK_PREFIXES_STR);
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEFAULT_EXCLUDE_TASK_PREFIXES.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(DEFAULT_EXCLUDE_TASK_PREFIXES[i]);
        }
        instrumentation_executor_exclude_task_prefixes = DEFAULT_EXCLUDE_TASK_PREFIXES_STR = sb.toString();
    }
}

