/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.boot;

import java.lang.instrument.ClassDefinition;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Properties;
import whatap.Version;
import whatap.agent.AgentTransformer;
import whatap.agent.ConfPrint;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.asm.weaving.WeaveMain;
import whatap.agent.boot.AgentProperty;
import whatap.agent.boot.CloudPlatformHelper;
import whatap.agent.boot.JavaTypeEnum;
import whatap.agent.boot.ProcessTypeDetector;
import whatap.agent.boot.ServicePortFinder;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfHook;
import whatap.agent.counter.CountCollector;
import whatap.agent.counter.task.AgentInfo;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.agent.stat.TimingSender;
import whatap.agent.tools.KubeUtil;
import whatap.agent.trace.httpc.urlnorm.HttpcURLNormBuilder;
import whatap.agent.trace.urlnorm.UrlNormPathTreeBuilder;
import whatap.agent.util.AsyncRunner;
import whatap.agent.util.CpuProfile;
import whatap.lang.pack.ParamPack;
import whatap.lang.value.BooleanValue;
import whatap.util.AnsiPrint;
import whatap.util.CastUtil;
import whatap.util.ClassUtil;
import whatap.util.DateUtil;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.ParamText;
import whatap.util.ShellArg;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class AgentBoot
extends Thread {
    private static AgentBoot instance;
    public static boolean can_redefine;
    static boolean loadAsync;
    long bootStart;
    public static boolean done;
    public static boolean pre_main_start;

    public static final synchronized void boot(String option) {
        if (instance == null) {
            instance = new AgentBoot();
            try {
                loadAsync = System.getProperty("whatap.boot.async") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loadAsync) {
                AgentBoot.bootLoad();
            }
            instance.setDaemon(true);
            instance.setName("WhaTap-AgentBoot");
            instance.start();
        }
    }

    private AgentBoot() {
    }

    public void run() {
        try {
            this.bootStart = System.currentTimeMillis();
            this.booting();
        }
        catch (Throwable t) {
            Logger.println(t.toString(), t);
        }
    }

    public static void bootLoad() {
        if (AgentBoot.checkOsgi()) {
            if (System.getProperty("whatap.home") == null) {
                String home = JarUtil.getJarLocation(AgentBoot.class);
                System.setProperty("whatap.home", home);
            }
            try {
                Configure conf = Configure.getInstance();
                conf.reload();
                if (conf.shutdown) {
                    return;
                }
                Logger.start();
                WeaveMain.load();
                if (JavaAgent.instrumentation != null) {
                    JavaAgent.instrumentation.addTransformer(AgentTransformer.getInstance());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void booting() {
        if (loadAsync) {
            AgentBoot.bootLoad();
        }
        Configure conf = Configure.getInstance();
        System.setProperty("whatap.enabled", "true");
        this.autoAgentNameOrPattern();
        if (conf.boot_wait_time > 0L) {
            try {
                while (System.currentTimeMillis() - this.bootStart < conf.boot_wait_time) {
                    ThreadUtil.sleep(500L);
                }
            }
            catch (Throwable t) {
                Logger.red(t.toString());
            }
        }
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster securityMaster = SecurityMaster.getInstance();
        securityMaster.init();
        int type = ProcessTypeDetector.findType();
        String apType = JavaTypeEnum.getNameByType(type);
        System.setProperty("apType", apType);
        if (Configure.getInstance()._enable_boot_file) {
            this.redefineFileClasses();
        }
        Logo.print();
        if (System.getProperty("whatap.batch") == null) {
            this.printDebug();
        }
        long seed = System.nanoTime() ^ (long)securityMaster.OID;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        DataTextAgent.getInstance().add((byte)13, securityMaster.OID, securityMaster.ONAME);
        AgentProperty.send();
        Logger.println("AgentBoot", "Counter collector start");
        CountCollector.getInstance();
        TimingSender.startInstance();
        if (ConfDebug.debug_cpu_enabled) {
            CpuProfile.getInstance();
        }
        Properties sysProp = System.getProperties();
        ParamPack param = new ParamPack();
        AgentBoot.copy(sysProp, param, "java.version");
        AgentBoot.copy(sysProp, param, "java.vendor");
        AgentBoot.copy(sysProp, param, "java.home");
        AgentBoot.copy(sysProp, param, "os.name");
        AgentBoot.copy(sysProp, param, "os.arch");
        AgentBoot.copy(sysProp, param, "file.encoding");
        AgentBoot.copy(sysProp, param, "user.country");
        AgentBoot.copy(sysProp, param, "user.timezone");
        AgentBoot.copy(sysProp, param, "user.language");
        AgentBoot.copy(sysProp, param, "user.home");
        AgentBoot.copy(sysProp, param, "user.dir");
        AgentBoot.copy(sysProp, param, "catalina.base");
        AgentBoot.copy(sysProp, param, "jboss.server.base.dir");
        AgentBoot.copy(sysProp, param, "whatap.jboss.version");
        AgentBoot.copy(sysProp, param, "whatap.undertow.version");
        AgentBoot.copy(sysProp, param, "whatap.jvm.cmd");
        AgentBoot.copy(sysProp, param, "whatap.error");
        AgentBoot.copy(sysProp, param, "jboss.modules.system.pkgs");
        RuntimeMXBean rmx = ManagementFactory.getRuntimeMXBean();
        List<String> cmdArgs = rmx.getInputArguments();
        for (int i = 0; i < cmdArgs.size(); ++i) {
            String x = cmdArgs.get(i);
            if (x.startsWith("-Xm") || x.startsWith("-Xs")) {
                param.put(x.substring(0, 4), x.substring(4));
                continue;
            }
            if (x.equals("-Xint")) {
                param.put("-Xint", new BooleanValue(true));
                continue;
            }
            if (!ConfPrint.print_agent_boot_jvm_args_enabled) continue;
            System.out.println(x);
        }
        if (pre_main_start) {
            param.put("whatap.boot.start", "premain");
        } else {
            param.put("whatap.boot.start", "agentmain");
        }
        if (!can_redefine) {
            param.put("whatap.boot.redefine", "false");
        }
        param.put("java.name", rmx.getName());
        param.put("java.start", DateUtil.timestamp(rmx.getStartTime()));
        AgentBoot.copy(sysProp, param, "whatap.pid");
        AgentBoot.copy(sysProp, param, "whatap.home");
        AgentBoot.copy(sysProp, param, "whatap.ip");
        AgentBoot.copy(sysProp, param, "whatap.port");
        AgentBoot.copy(sysProp, param, "whatap.oid");
        AgentBoot.copy(sysProp, param, "whatap.oname");
        AgentBoot.copy(sysProp, param, "whatap.name");
        param.put("whatap.version", Version.getFullVersion());
        AgentBoot.copy(sysProp, param, "whatap.type");
        System.setProperty("whatap.version", Version.getFullVersion());
        KubeUtil.loadContainerId();
        if (KubeUtil.container_id != null) {
            System.setProperty("whatap.container", KubeUtil.container_id);
            param.put("whatap.container", KubeUtil.container_id);
        }
        CloudPlatformHelper.update(param);
        if (type == 0) {
            type = ProcessTypeDetector.findType();
            apType = JavaTypeEnum.getNameByType(type);
            System.setProperty("apType", apType);
            param.put("apType", apType);
        }
        DataPackSender.sendBoot(param);
        AgentInfo.info = param;
        Logger.println(param.toFormatString());
        AgentBoot.hookHttpURLConnection();
        if (Configure.getInstance().trace_normalize_enabled) {
            long time1 = System.currentTimeMillis() - rmx.getUptime() + conf.boot_scan_wait_time;
            long time2 = System.currentTimeMillis() + 10000L;
            UrlNormPathTreeBuilder.start(Math.max(time1, time2));
        }
        if (Configure.getInstance().trace_httpc_normalize_enabled) {
            HttpcURLNormBuilder.start();
        }
        AgentBoot.threadHook();
        if (Configure.getInstance().shutdown_hook_enabled) {
            this.addShutdownHook();
        }
        done = true;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DataPackSender.sendShutdownSignal();
                ThreadUtil.sleep(100L);
                Logger.println("Execute shutdown hook");
            }
        });
    }

    private void printDebug() {
        Configure conf = Configure.getInstance();
        if (conf.WHATAP_MICRO_ENABLED) {
            System.out.println(AnsiPrint.green("whatap.micro.enabled = true"));
        }
        if (!ConfHook._enable_asm_http) {
            System.out.println(AnsiPrint.green("_enable_asm_http = false"));
        }
        if (!ConfHook._enable_asm_nonhttp) {
            System.out.println(AnsiPrint.green("_enable_asm_nonhttp = false"));
        }
        if (!ConfHook._enable_asm_jdbc) {
            System.out.println(AnsiPrint.green("_enable_asm_jdbc = false"));
        }
        if (!ConfHook._enable_asm_method) {
            System.out.println(AnsiPrint.green("_enable_asm_method = false"));
        }
        if (!ConfHook._enable_asm_etc) {
            System.out.println(AnsiPrint.green("_enable_asm_etc = false"));
        }
        if (!ConfHook._enable_asm_async) {
            System.out.println(AnsiPrint.green("_enable_asm_async = false"));
        }
        if (!ConfHook._enable_emb_httpc) {
            System.out.println(AnsiPrint.green("_enable_emb_httpc = false"));
        }
        if (!ConfHook._enable_emb_tools) {
            System.out.println(AnsiPrint.green("_enable_emb_tools = false"));
        }
        if (!conf._enable_boot_file) {
            System.out.println(AnsiPrint.green("_enable_boot_file = false"));
        }
    }

    private void autoAgentNameOrPattern() {
        Configure conf = Configure.getInstance();
        String oname = System.getProperty("whatap.oname");
        if (StringUtil.isNotEmpty(oname)) {
            if (conf.auto_oname_enabled) {
                System.setProperty("whatap.oname", "");
            }
            return;
        }
        if (conf.auto_oname_enabled) {
            return;
        }
        int type = 0;
        if (StringUtil.isNotEmpty(conf.object_name)) {
            System.setProperty("whatap.name", conf.object_name);
        }
        if (conf.WHATAP_MICRO_ENABLED) {
            if (System.getProperty("whatap.name") == null) {
                System.setProperty("whatap.name", "{okind}-{ip2}-{ip3}");
            }
            return;
        }
        String reserved = System.getProperty("whatap.name");
        if (reserved != null && reserved.indexOf("{") < 0) {
            return;
        }
        if (conf._enable_boot_scan) {
            while (type == 0) {
                type = ProcessTypeDetector.findType();
                ThreadUtil.sleep(2000L);
                if (System.currentTimeMillis() - this.bootStart < conf.was_init_wait_time) continue;
            }
        }
        System.setProperty("whatap.type", JavaTypeEnum.values.get(type));
        switch (type) {
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                if (!conf._enable_boot_scan || !this.isRequiredSearchingServicePort()) break;
                this.searchPort(type);
            }
        }
        if (!conf._enable_boot_scan) {
            System.setProperty("whatap.name", "{type}-{ip2}-{ip3}-{pid}");
        } else if (System.getProperty("whatap.name") == null) {
            switch (type) {
                case 7: {
                    this.jeusNamePattern();
                    break;
                }
                default: {
                    if (CastUtil.cint(System.getProperty("whatap.port", "0")) > 0) {
                        System.setProperty("whatap.name", "{type}-{ip2}-{ip3}-{port}");
                        break;
                    }
                    System.setProperty("whatap.name", "{type}-{ip2}-{ip3}-{pid}");
                }
            }
        }
    }

    private void redefineFileClasses() {
        if (JavaAgent.instrumentation == null) {
            return;
        }
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        int done = 0;
        for (Class c : loadedClasses) {
            byte[] body;
            if (!c.getName().equals("java.io.FileInputStream") && !c.getName().equals("java.io.FileOutputStream") || (body = ClassUtil.getByteCode(c)) == null) continue;
            AsyncRunner.getInstance().add(null, c.getName().replace('.', '/'), body);
            if (++done != 2) continue;
            return;
        }
    }

    public boolean isRequiredSearchingServicePort() {
        boolean ok;
        boolean bl = ok = CastUtil.cint(System.getProperty("whatap.port", "0")) == 0;
        if (!ok) {
            return false;
        }
        String name = System.getProperty("whatap.name");
        if (name == null) {
            return true;
        }
        ParamText p = new ParamText(name, "{", "}");
        List<String> keyList = p.getKeyList();
        for (int i = 0; i < keyList.size(); ++i) {
            if (!"port".equals(keyList.get(i))) continue;
            return true;
        }
        return false;
    }

    public void jeusNamePattern() {
        String cmd = System.getProperty("sun.java.command", "");
        if (cmd.indexOf("jeus.server.ServerBootstrapper") >= 0) {
            ShellArg arg = new ShellArg(StringUtil.tokenizer(cmd, " "));
            String server = arg.get("-server");
            if (server != null) {
                System.setProperty("whatap.name", "{type}-{ip2}-{ip3}-" + server);
            } else {
                System.setProperty("whatap.name", "{type}-{ip2}-{ip3}-{pid}");
            }
        } else {
            System.setProperty("whatap.name", "{type}-{ip2}-{ip3}-{cmd1}");
        }
    }

    public void searchPort(int type) {
        int port = 0;
        for (int i = 0; i < 3 && port == 0; ++i) {
            port = ServicePortFinder.search(type);
            if (port != 0) continue;
            ThreadUtil.sleep(10000L);
        }
        if (port >= 0) {
            System.setProperty("whatap.port", Integer.toString(port));
        }
    }

    private static boolean checkOsgi() {
        String s = System.getProperty("jboss.modules.system.pkgs");
        if (s != null && s.indexOf("whatap") < 0) {
            System.setProperty("whatap.error", "please check -Djboss.modules.system.pkgs in JBOSS");
            Logger.println("A159", 10, "can't find 'whatap' in -Djboss.modules.system.pkgs");
            return false;
        }
        return true;
    }

    private static void copy(Properties sysp, ParamPack map, String key) {
        if (sysp.containsKey(key)) {
            map.put(key, sysp.getProperty(key));
        }
    }

    private static void hookHttpURLConnection() {
        if (ConfHook.hook_HttpURLConnection_startup_enabled) {
            try {
                Class.forName("sun.net.www.protocol.http.HttpURLConnection");
            }
            catch (ClassNotFoundException e) {
                Logger.println("Redefine HttpURLConnection on startup", e);
            }
        }
        if (ConfHook.hook_HttpURLConnection_weblogic_startup_enabled) {
            try {
                Class.forName("weblogic.net.http.HttpURLConnection");
            }
            catch (ClassNotFoundException e) {
                Logger.println("Redefine weblogic HttpURLConnection on startup", e);
            }
        }
    }

    private static void threadHook() {
        if (ConfHook.hook_thread_start_enabled) {
            try {
                Logger.println("Thread Trace Enabled");
                Class<Thread> c = Thread.class;
                byte[] body = ClassUtil.getByteCode(c);
                if (body != null) {
                    JavaAgent.instrumentation.redefineClasses(new ClassDefinition(c, body));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void waitDone() {
        while (!done) {
            ThreadUtil.sleep(100L);
        }
    }

    static {
        can_redefine = true;
        loadAsync = false;
        done = false;
    }
}

