/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.util;

import java.util.Map;
import whatap.agent.asm.util.HookingSet;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmUtil
implements Opcodes {
    public static Type stringType = Type.getType(String.class);

    public static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public static boolean isPublic(int access) {
        return (access & 1) != 0;
    }

    public static boolean isAbstract(int access) {
        return (access & 0x400) != 0;
    }

    public static String makeMethodFullName(String className, String methodName, String methodSignature) {
        return new StringBuffer().append(className.replace('/', '.')).append(".").append(methodName).append(methodSignature).toString();
    }

    public static String makeClassAndMethod(String className, String methodName) {
        return new StringBuffer().append(className.replace('/', '.')).append("#").append(methodName).toString();
    }

    public static void add(Map<String, HookingSet> classSet, String klass, String method) {
        HookingSet mset = classSet.get(klass = klass.replace('.', '/'));
        if (mset == null) {
            mset = new HookingSet();
            classSet.put(klass, mset);
        }
        mset.add(method);
    }

    public static void PUSH(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn(new Integer(value));
        }
    }

    public static void PUSH(MethodVisitor mv, boolean value) {
        mv.visitInsn(3 + (value ? 1 : 0));
    }

    public static void PUSH(MethodVisitor mv, float value) {
        if ((double)value == 0.0) {
            mv.visitInsn(11);
        } else if ((double)value == 1.0) {
            mv.visitInsn(12);
        } else if ((double)value == 2.0) {
            mv.visitInsn(13);
        } else {
            mv.visitLdcInsn(new Float(value));
        }
    }

    public static void PUSH(MethodVisitor mv, long value) {
        if (value == 0L) {
            mv.visitInsn(9);
        } else if (value == 1L) {
            mv.visitInsn(10);
        } else {
            mv.visitLdcInsn(new Long(value));
        }
    }

    public static void PUSH(MethodVisitor mv, double value) {
        if (value == 0.0) {
            mv.visitInsn(14);
        } else if (value == 1.0) {
            mv.visitInsn(15);
        } else {
            mv.visitLdcInsn(new Double(value));
        }
    }

    public static void PUSHNULL(MethodVisitor mv) {
        mv.visitInsn(1);
    }

    public static void PUSH(MethodVisitor mv, String value) {
        if (value == null) {
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    public static void PUSH(MethodVisitor mv, Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            AsmUtil.PUSH(mv, value.intValue());
        } else if (value instanceof Double) {
            AsmUtil.PUSH(mv, value.doubleValue());
        } else if (value instanceof Float) {
            AsmUtil.PUSH(mv, value.floatValue());
        } else if (value instanceof Long) {
            AsmUtil.PUSH(mv, value.longValue());
        } else {
            throw new RuntimeException("What's this: " + value);
        }
    }

    public static void PUSH(MethodVisitor mv, Character value) {
        AsmUtil.PUSH(mv, (int)value.charValue());
    }

    public static void PUSH(MethodVisitor mv, Boolean value) {
        AsmUtil.PUSH(mv, (boolean)value);
    }

    public static int getStringIdx(int access, String desc) {
        Type[] t = Type.getArgumentTypes(desc);
        int sidx = AsmUtil.isStatic(access) ? 0 : 1;
        for (int i = 0; t != null && i < t.length; ++i) {
            if (stringType.equals(t[i])) {
                return sidx;
            }
            sidx += t[i].getSize();
        }
        return -1;
    }

    public static int getTypeIdx(int access, String desc, Type sqlParamType) {
        Type[] t = Type.getArgumentTypes(desc);
        int sidx = AsmUtil.isStatic(access) ? 0 : 1;
        for (int i = 0; t != null && i < t.length; ++i) {
            if (sqlParamType.equals(t[i])) {
                return sidx;
            }
            sidx += t[i].getSize();
        }
        return -1;
    }

    public static int getArgLen(String desc) {
        Type[] t = Type.getArgumentTypes(desc);
        return t.length;
    }

    public static boolean isSpecial(String name) {
        return name.indexOf("$") >= 0 || name.startsWith("<");
    }

    public static boolean isInitMethod(String name) {
        return name.startsWith("<");
    }

    public static boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    public static String getReturnString(String desc) {
        Type t = Type.getReturnType(desc);
        return AsmUtil.type2str(t);
    }

    public static String getArgString(String desc) {
        Type[] ar = Type.getArgumentTypes(desc);
        String[] ar2 = AsmUtil.type2str(ar);
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < ar2.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ar2[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getMethodAccessString(int access, boolean isInterface) {
        StringBuffer buf = new StringBuffer();
        if ((access & 1) != 0) {
            buf.append("public ");
        } else if ((access & 2) != 0) {
            buf.append("private ");
        } else if ((access & 4) != 0) {
            buf.append("protected ");
        } else {
            buf.append("       ");
        }
        if ((access & 0x10) != 0) {
            buf.append("final ");
        }
        if ((access & 8) != 0) {
            buf.append("static ");
        }
        if ((access & 0x20) != 0) {
            buf.append("synchronized ");
        }
        if ((access & 0x40) != 0) {
            buf.append("volatile ");
        }
        if ((access & 0x80) != 0) {
            buf.append("transient ");
        }
        if (!isInterface && (access & 0x400) != 0) {
            buf.append("abstract ");
        }
        if ((access & 0x800) != 0) {
            buf.append("strictfp ");
        }
        if ((access & 0x1000) != 0) {
            buf.append("synthetic ");
        }
        if ((access & 0x8000) != 0) {
            buf.append("mandated ");
        }
        if ((access & 0x4000) != 0) {
            buf.append("enum ");
        }
        return buf.toString();
    }

    public static String getClassAccessString(int access) {
        boolean isInterface = AsmUtil.isInterface(access);
        StringBuffer buf = new StringBuffer();
        if ((access & 1) != 0) {
            buf.append("public ");
        }
        if ((access & 2) != 0) {
            buf.append("private ");
        }
        if ((access & 4) != 0) {
            buf.append("protected ");
        }
        if ((access & 0x10) != 0) {
            buf.append("final ");
        }
        if ((access & 8) != 0) {
            buf.append("static ");
        }
        if (!isInterface && (access & 0x400) != 0) {
            buf.append("abstract ");
        }
        if ((access & 0x800) != 0) {
            buf.append("strictfp ");
        }
        if ((access & 0x1000) != 0) {
            buf.append("synthetic ");
        }
        if ((access & 0x8000) != 0) {
            buf.append("mandated ");
        }
        if ((access & 0x4000) != 0) {
            buf.append("enum ");
        }
        if (isInterface) {
            buf.append("interface ");
        } else {
            buf.append("class ");
        }
        return buf.toString();
    }

    private static String[] type2str(Type[] types) {
        if (types == null) {
            throw new IllegalArgumentException("Types was null!");
        }
        String[] clz = new String[types.length];
        for (int i = 0; i < clz.length; ++i) {
            clz[i] = AsmUtil.type2str(types[i]);
        }
        return clz;
    }

    private static String type2str(Type t) {
        switch (t.getSort()) {
            case 10: {
                return t.getClassName();
            }
            case 7: {
                return Long.TYPE.getName();
            }
            case 6: {
                return Float.TYPE.getName();
            }
            case 8: {
                return Double.TYPE.getName();
            }
            case 3: {
                return Byte.TYPE.getName();
            }
            case 5: {
                return Integer.TYPE.getName();
            }
            case 1: {
                return Boolean.TYPE.getName();
            }
            case 4: {
                return Short.TYPE.getName();
            }
            case 2: {
                return Character.TYPE.getName();
            }
            case 9: {
                return AsmUtil.type2str(t.getElementType()) + "[]";
            }
            case 0: {
                return "void";
            }
        }
        throw new IllegalArgumentException("Invalid argument type: " + t.getSort());
    }

    public static String infToString(String[] inf) {
        if (inf == null || inf.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inf.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(inf[i].replace('/', '.'));
        }
        return sb.toString();
    }
}

