/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.logsink;

import whatap.agent.asm.IASM;
import whatap.logsink.fw.LogTracer;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class LogCustomMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String HOOK_CLASS = LogTracer.class.getName().replace('.', '/');
    private static final String METHOD_NAME = "logcustom";
    private static final String METHOD_SIGNATURE = "(Ljava/lang/String;)V";
    private boolean isStatic;
    private Type[] paramTypes;

    public LogCustomMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic) {
        super(IASM.API, access, desc, mv);
        this.isStatic = isStatic;
        this.paramTypes = paramTypes;
    }

    public void visitCode() {
        boolean flag = false;
        int sidx = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type tp = this.paramTypes[i];
            if ("java/lang/String".equals(tp.getInternalName())) {
                this.mv.visitVarInsn(25, sidx);
                flag = true;
                break;
            }
            sidx += tp.getSize();
        }
        if (!flag) {
            this.mv.visitInsn(1);
        }
        this.mv.visitMethodInsn(184, HOOK_CLASS, METHOD_NAME, METHOD_SIGNATURE, false);
        this.mv.visitCode();
    }
}

