/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.jdbc;

import whatap.agent.asm.IASM;
import whatap.agent.asm.jdbc.JdbcAsm;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.conf.ConfHook;
import whatap.agent.trace.SqlParameter;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

public class PsInitMV4Pre
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACESQL = JdbcAsm.TRACE_SQL;
    private static final String METHOD = "prepare";
    private static final String SIGNATURE = "(Ljava/lang/Object;Lwhatap/agent/trace/SqlParameter;Ljava/lang/String;)V";
    private static final String METHOD_INIT = "stmtInit";
    private static final String SIGNATURE_INIT = "(Ljava/lang/Object;)V";
    private String owner;
    private int sqlIdx = -1;
    private boolean isUstatement = false;
    private boolean isPgStatement = false;
    private boolean isObject;

    public PsInitMV4Pre(int access, String desc, MethodVisitor mv, String owner, String sqlParamType) {
        super(IASM.API, access, desc, mv);
        this.owner = owner;
        if (sqlParamType != null) {
            this.isObject = true;
            this.sqlIdx = AsmUtil.getTypeIdx(access, desc, Type.getType(sqlParamType));
        } else {
            this.sqlIdx = AsmUtil.getStringIdx(access, desc);
        }
        if (this.sqlIdx < 0 && ConfHook.hook_jdbc_pstmt_none_sql_enabled) {
            if (owner.equals("org/postgresql/jdbc/PgPreparedStatement")) {
                this.sqlIdx = AsmUtil.getTypeIdx(access, desc, Type.getType("Lorg/postgresql/core/CachedQuery;"));
                this.isPgStatement = true;
            } else if (owner.indexOf("cubrid") >= 0) {
                this.sqlIdx = AsmUtil.getTypeIdx(access, desc, Type.getType("Lcubrid/jdbc/jci/UStatement;"));
                this.isUstatement = true;
            }
        }
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, TRACESQL, METHOD_INIT, SIGNATURE_INIT, false);
            if (this.sqlIdx >= 0) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.owner, "_wsqlparam_", "Lwhatap/agent/trace/SqlParameter;");
                Label end = new Label();
                this.mv.visitJumpInsn(199, end);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitTypeInsn(187, Type.getInternalName(SqlParameter.class));
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(183, Type.getInternalName(SqlParameter.class), "<init>", "()V", false);
                this.mv.visitFieldInsn(181, this.owner, "_wsqlparam_", "Lwhatap/agent/trace/SqlParameter;");
                this.mv.visitLabel(end);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.owner, "_wsqlparam_", "Lwhatap/agent/trace/SqlParameter;");
                this.mv.visitVarInsn(25, this.sqlIdx);
                if (this.isObject) {
                    this.mv.visitMethodInsn(184, "whatap/util/CastUtil", "cString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
                } else if (this.isUstatement) {
                    this.mv.visitMethodInsn(182, "cubrid/jdbc/jci/UStatement", "getQuery", "()Ljava/lang/String;", false);
                } else if (this.isPgStatement) {
                    this.mv.visitFieldInsn(180, "org/postgresql/core/CachedQuery", "query", "Lorg/postgresql/core/Query;");
                    this.mv.visitMethodInsn(185, "org/postgresql/core/Query", "getNativeSql", "()Ljava/lang/String;", true);
                }
                this.mv.visitMethodInsn(184, TRACESQL, METHOD, SIGNATURE, false);
            }
        }
        this.mv.visitInsn(opcode);
    }
}

