/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.TraceHelperExtCV;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class TraceHelperASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_trace_helper_patterns);
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.reserved.keySet());
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_methods_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new TraceHelperExtCV(cv, mset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new TraceHelperExtCV(cv, mset, className);
        }
        return cv;
    }
}

