/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.jdbc.PsCloseMV;
import whatap.agent.asm.jdbc.StExecute;
import whatap.agent.asm.jdbc.StExecuteBatch;
import whatap.agent.asm.jdbc.StExecuteQuery;
import whatap.agent.asm.jdbc.StExecuteUpdate;
import whatap.agent.asm.jdbc.StInitMV;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class StatementCV
extends ClassVisitor
implements Opcodes {
    private String owner;

    public StatementCV(ClassVisitor cv) {
        super(IASM.API, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.owner = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<init>".equals(name)) {
            return new StInitMV(access, desc, mv, this.owner, name);
        }
        if ("close".equals(name) && "()V".equals(desc)) {
            return new PsCloseMV(access, desc, mv, this.owner);
        }
        if (desc.startsWith("(Ljava/lang/String;)")) {
            if (name.equals("execute")) {
                return new StExecute(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeUpdate")) {
                return new StExecuteUpdate(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeQuery")) {
                return new StExecuteQuery(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeBatch")) {
                return new StExecuteBatch(access, desc, mv, this.owner, name);
            }
        }
        return mv;
    }
}

