/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.SocketCV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class SocketASM
extends IASM
implements Opcodes {
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.reserved.keySet());
    }

    public SocketASM() {
        AsmUtil.add(this.reserved, "java/net/Socket", "connect(Ljava/net/SocketAddress;I)V");
        AsmUtil.add(this.reserved, "java/net/Socket", "getInputStream()Ljava/io/InputStream;");
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_socket_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new SocketCV(cv, mset, className);
        }
        return cv;
    }
}

