/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.JspServletCV;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.Pair;

public class JspServletASM
extends IASM
implements Opcodes {
    private Map<String, HookingSet> target = HookingSet.getHookingSet(ConfHook.hook_jsp_patterns);

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target.keySet());
    }

    public JspServletASM() {
        AsmUtil.add(this.target, "org/apache/jasper/servlet/JspServlet", "serviceJspFile");
        for (int i = JspTargetRegister.klassMethod.size() - 1; i >= 0; --i) {
            AsmUtil.add(this.target, JspTargetRegister.klassMethod.get(i).getLeft(), JspTargetRegister.klassMethod.get(i).getRight());
        }
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        HookingSet mset = this.target.get(className);
        if (mset == null) {
            return cv;
        }
        return new JspServletCV(cv, mset, className);
    }

    public static class JspTargetRegister {
        public static final List<Pair<String, String>> klassMethod = new ArrayList<Pair<String, String>>();

        public static void regist(String klass, String method) {
            klassMethod.add(new Pair<String, String>(klass, method));
        }
    }
}

