/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.StatementCV;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class JDBCStatementASM
extends IASM
implements Opcodes {
    public final HashSet<String> target = HookingSet.getHookingClassSet(ConfHook.hook_jdbc_stmt_classes);

    public JDBCStatementASM() {
        if (!ConfHook.hook_jdbc_stmt_default_enabled) {
            return;
        }
        this.target.add("org/mariadb/jdbc/MySQLStatement");
        if (ConfHook.hook_oracle_stmt_enabled) {
            this.target.add("oracle/jdbc/driver/OracleStatement");
        }
        this.target.add("com/mysql/jdbc/StatementImpl");
        this.target.add("com/mysql/cj/jdbc/StatementImpl");
        this.target.add("org/apache/derby/impl/jdbc/EmbedStatement");
        this.target.add("org/apache/derby/client/am/Statement");
        this.target.add("bmt/jdbc/FakeStatement");
        this.target.add("jdbc/FakeStatement");
        this.target.add("net/sourceforge/jtds/jdbc/JtdsStatement");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerStatement");
        this.target.add("com/tmax/tibero/jdbc/TbStatement");
        this.target.add("org/hsqldb/jdbc/JDBCStatement");
        this.target.add("cubrid/jdbc/driver/CUBRIDStatement");
        this.target.add("org/mariadb/jdbc/MariaDbStatement");
        this.target.add("org/postgresql/jdbc/PgStatement");
        this.target.add("com/edb/jdbc/PgStatement");
        this.target.add("com/ibm/as400/access/AS400JDBCStatement");
        this.target.add("com/informix/jdbc/IfxStatement");
        this.target.add("Altibase/jdbc/driver/AltibaseStatement");
        this.target.add("Altibase/jdbc/driver/ABRStatement");
        this.target.add("Altibase5/jdbc/driver/ABStatement");
        this.target.add("com/tmax/tibero/jdbc/TbStatement");
        this.target.add("com/tmax/tibero/jdbc/driver/TbStatement");
        this.target.add("org/h2/jdbc/JdbcStatement");
        this.target.add("com/sybase/jdbc2/jdbc/SybStatement");
        this.target.add("com/sybase/jdbc4/jdbc/SybStatement");
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_dbsql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("BCI", "jdbc-stmt " + className);
        return new StatementCV(cv);
    }
}

