/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.DbcOpenCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class JDBCConnectionOpenASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_connection_open_patterns);
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public JDBCConnectionOpenASM() {
        if (!ConfHook.hook_connection_open_default_enabled) {
            return;
        }
        AsmUtil.add(this.reserved, "org/apache/commons/dbcp/BasicDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "org/apache/tomcat/dbcp/dbcp/BasicDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "org/apache/tomcat/jdbc/pool/DataSourceProxy", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "org/apache/tomcat/dbcp/dbcp2/BasicDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "org/apache/commons/dbcp2/BasicDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "jeus/jdbc/connectionpool/DataSourceWrapper", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "jeus/jdbc/datasource/DataSourceWrapper", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "com/zaxxer/hikari/HikariDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "weblogic/jdbc/common/internal/RmiDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "org/jboss/jca/adapters/jdbc/WrapperDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "com/jolbox/bonecp/BoneCPDataSource", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "com/alibaba/druid/pool/DruidPooledConnection", "getConnection()Ljava/sql/Connection;");
        AsmUtil.add(this.reserved, "bmt/ds/MyDataSource", "getConnection()Ljava/sql/Connection;");
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.reserved.keySet());
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_dbopen_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new DbcOpenCV(cv, mset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new DbcOpenCV(cv, mset, className);
        }
        return cv;
    }
}

