/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.CallableStatementCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.Pair;

public class JDBCCallableStatementASM
extends IASM
implements Opcodes {
    public static HashSet<Pair<String, String>> ignoreInit = new HashSet();
    public final HashSet<String> target = HookingSet.getHookingClassSet(ConfHook.hook_jdbc_cstmt_classes);

    public JDBCCallableStatementASM() {
        if (!ConfHook.hook_jdbc_cstmt_default_enabled) {
            return;
        }
        this.target.add("org/postgresql/jdbc/PgCallableStatement");
        this.target.add("com/edb/jdbc/PgCallableStatement");
        this.target.add("com/tmax/tibero/jdbc/TbCallableStatement");
        this.target.add("com/tmax/tibero/jdbc/driver/TbCallableStatementImpl");
        if (ConfHook.hook_oracle_cstmt_enabled) {
            this.target.add("oracle/jdbc/driver/OracleCallableStatement");
        }
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_dbsql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("BCI", "jdbc-cstmt " + className);
        return new CallableStatementCV(cv);
    }
}

