/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.DbcCloseMV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.HookingSet;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.HashUtil;
import whatap.util.StringUtil;

class DbcCloseCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;

    public DbcCloseCV(ClassVisitor cv, HookingSet mset, String className) {
        super(IASM.API, cv);
        this.mset = mset;
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        Logger.println("BCI", "jdbc-con-close " + this.className);
        this.className = StringUtil.cutLastString(this.className, '/');
        String fullname = new StringBuilder(100).append("[").append(this.className).append("].CLOSE-DBC()").toString();
        int fullname_hash = HashUtil.hash(fullname);
        return new DbcCloseMV(access, desc, mv, fullname_hash, fullname);
    }
}

