/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.JDBCCallableStatementASM;
import whatap.agent.asm.jdbc.CstmtInitMV4Pre;
import whatap.agent.asm.jdbc.CstmtSetMV;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.Pair;

class CallableStatementCV
extends ClassVisitor
implements Opcodes {
    private String owner;

    public CallableStatementCV(ClassVisitor cv) {
        super(IASM.API, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.owner = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<init>".equals(name)) {
            if (!JDBCCallableStatementASM.ignoreInit.contains(new Pair<String, String>(this.owner, desc)) && ConfHook.sqlparam_field_enabled) {
                return new CstmtInitMV4Pre(access, desc, mv, this.owner);
            }
        } else {
            String targetDesc = CstmtSetMV.getSetSignature(name);
            if (targetDesc != null && ConfHook.sqlparam_field_enabled && (desc.equals(targetDesc) || desc.startsWith(targetDesc))) {
                return new CstmtSetMV(access, name, desc, mv, this.owner);
            }
        }
        return mv;
    }
}

