/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import java.lang.ref.WeakReference;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.ParamSecurity;
import whatap.agent.SecurityMaster;
import whatap.agent.app.AppCtxStatCollector;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.tx.MeterServiceBackground;
import whatap.agent.data.DataProfileAgent;
import whatap.agent.data.DataTextAgent;
import whatap.agent.plugin.PluginAppServiceEnd;
import whatap.agent.plugin.PluginAppServiceStart;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.TraceSamplingManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.lang.pack.ProfilePack;
import whatap.lang.service.TxRecord;
import whatap.lang.step.MessageStepX;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.TextValue;
import whatap.notice.REQUEST_REJECT;
import whatap.notice.WHATAP_ERROR;
import whatap.util.BitUtil;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.IntSet;
import whatap.util.KeyGen;
import whatap.util.LinkedMap;
import whatap.util.StrMatch;
import whatap.util.SysJMX;

public class TxTraceBackground {
    protected static Configure conf = Configure.getInstance();
    public static LinkedMap<Object, WeakReference<TraceContext>> txTraceMap = new LinkedMap().setMax(TxTraceBackground.conf.trace_attach_link_max);
    protected static Error REJECT = new REQUEST_REJECT("rejected request");
    static ThreadLocal sampling = new ThreadLocal();

    public void service(String name) {
        if (name == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            ctx.service_hash = HashUtil.hash(name);
            ctx.service_name = name;
        }
    }

    public static TraceContext startTx(String name, String className, String methodName, String methodDesc, Object _this, Object[] arg) {
        if (!TxTraceBackground.conf.transaction_enabled) {
            return null;
        }
        if (ConfTrace.trace_sampling_enabled) {
            if (sampling.get() != null) {
                return null;
            }
            if (!TraceSamplingManager.traceOk()) {
                sampling.set("off");
                return TraceContext.sampling();
            }
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (TraceContext.isActivated(ctx)) {
                return null;
            }
            ctx = TxTraceBackground._serviceStartRealTx(name);
            if (ctx != null) {
                ctx.isBackground = true;
            }
            PluginAppServiceStart.process(ctx, new HookArgs(className, methodName, methodDesc, _this, arg));
            return ctx;
        }
        catch (Throwable t) {
            Logger.println("ServiceTx", 10, t);
            return null;
        }
    }

    protected static TraceContext _serviceStartRealTx(String name) {
        TraceContext ctx = TxTraceBackground.startTrace(name);
        TraceContextManager.start(ctx);
        return ctx;
    }

    private static TraceContext startTrace(String name) {
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.thread = Thread.currentThread();
        ctx.service_hash = HashUtil.hash(name);
        ctx.service_name = name;
        ctx.resetStartTime();
        if (TxTraceBackground.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxTraceBackground.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        ctx.txid = KeyGen.next();
        return ctx;
    }

    public static TraceContext startTxForExecutor(TraceContext parentCtx, String taskName) {
        if (parentCtx == null) {
            return null;
        }
        long ctxid = KeyGen.next();
        int parentOffsetTime = parentCtx.getElapsedTime();
        String rootServiceName = TxTraceBackground.getRootServiceName(parentCtx.service_name);
        String serviceName = rootServiceName + " : " + taskName;
        long stepId = TxTraceBackground.createMessageStepInParent(parentCtx, serviceName, taskName, ctxid, parentOffsetTime);
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.thread = Thread.currentThread();
        ctx.txid = ctxid;
        ctx.mtid = parentCtx.mtid;
        ctx.mtid_build_checked = true;
        ctx.mdepth = parentCtx.mdepth;
        ctx.service_name = serviceName;
        ctx.service_hash = HashUtil.hash(ctx.service_name);
        ctx.mcaller_txid = parentCtx.txid;
        ctx.mcaller_stepId = stepId;
        if (TxTraceBackground.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxTraceBackground.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        ctx.resetStartTime(parentOffsetTime);
        ctx.extraFields().put("ParentTx", Long.toString(parentCtx.txid));
        ctx.extraFields().put("OffsetTime", Integer.toString(parentOffsetTime));
        ctx.isBackground = true;
        return ctx;
    }

    private static String getRootServiceName(String serviceName) {
        if (serviceName == null) {
            return "Unknown";
        }
        int colonIndex = serviceName.indexOf(" : ");
        if (colonIndex > 0) {
            return serviceName.substring(0, colonIndex);
        }
        if (serviceName.startsWith("(SubTx)")) {
            return serviceName.substring(7);
        }
        return serviceName;
    }

    private static long createMessageStepInParent(TraceContext parentCtx, String serviceName, String taskName, long ctxid, int parentOffsetTime) {
        MessageStepX step = new MessageStepX();
        step.start_time = parentCtx.getElapsedTime();
        step.title = serviceName;
        step.desc = taskName + "#" + ctxid;
        step.setAttr("ctxid", new DecimalValue(ctxid));
        step.setAttr("offset", new DecimalValue(parentOffsetTime));
        long stepId = KeyGen.next();
        step.setAttr("stepId", new DecimalValue(stepId));
        parentCtx.profile.add(step);
        return stepId;
    }

    public static void endTx(TraceContext ctx, Object rtn, Throwable thro) {
        try {
            if (ConfTrace.trace_sampling_enabled && ctx != null && ctx.isFake()) {
                sampling.set(null);
                return;
            }
            if (TraceContext.isNullOrClosed(ctx)) {
                return;
            }
            TxTraceBackground._serviceEndRealTx(ctx, rtn, thro);
        }
        catch (Throwable t) {
            Logger.println("EndTx", 10, t);
        }
    }

    protected static void _serviceEndRealTx(TraceContext ctx, Object rtn, Throwable thr) {
        ctx.close();
        ctx.handleEndTxErrorStack(thr);
        if (ConfTrace.trace_exception_overwrite_enabled && ctx.exception != null && ctx.error != null && ctx.exception != ctx.error.exception) {
            ctx.error = null;
        }
        String name = null;
        switch (TxTraceBackground.conf.service_name_mode) {
            case 6: {
                if (rtn == null) {
                    name = "null";
                    break;
                }
                ctx.service_name = name = rtn.toString();
                ctx.service_hash = HashUtil.hash(ctx.service_name);
            }
        }
        if (ConfTrace.trace_thread_id_enabled && ctx.thread != null) {
            ctx.setExtraField("threadId", new DecimalValue(ctx.thread.getId()));
        }
        if (ConfTrace.trace_thread_name_enabled && ctx.thread != null) {
            ctx.setExtraField("threadName", new TextValue(ctx.thread.getName()));
        }
        PluginAppServiceEnd.process(ctx, rtn);
        TraceContextManager.end(ctx.txid);
        boolean isNew = DataTextAgent.SERVICE.add(ctx.service_hash, ctx.service_name);
        ProfilePack profile = new ProfilePack();
        TxRecord tx = new TxRecord();
        tx.txid = ctx.txid;
        if (ConfTrace.txtext_txname_enabled) {
            tx.txName = ctx.service_name;
        }
        tx.wclientId = ctx.wclientId;
        tx.cipher = ParamSecurity.keyHash;
        tx.userAgent = ctx.userAgent;
        tx.mcaller_pcode = ctx.mcaller_pcode;
        tx.mcaller_okind = ctx.mcaller_okind;
        tx.mcaller_oid = ctx.mcaller_oid;
        tx.custid = ctx.custid;
        tx.mtid = ctx.mtid;
        tx.mdepth = ctx.mdepth;
        tx.mcaller = ctx.mcaller_txid;
        tx.mcallerStepId = ctx.mcaller_stepId;
        if (ConfTrace.trace_origin_url_enabled) {
            tx.originUrl = ctx.origin_url;
        }
        tx.endTime = ctx.endTime = DateUtil.currentTime();
        tx.elapsed = ctx.elapsed = ctx.getElapsedTime();
        if (tx.elapsed < 0) {
            ctx.elapsed = 0;
            tx.elapsed = 0;
        }
        tx.service = ctx.service_hash;
        if (ctx.start_cpu > 0L) {
            tx.cpuTime = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
        }
        if (ctx.start_malloc > 0L) {
            tx.malloc = SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc;
        }
        tx.sqlCount = ctx.sql_count;
        tx.sqlTime = ctx.sql_time;
        tx.sqlFetchCount = ctx.rs_count;
        tx.sqlFetchTime = (int)ctx.rs_time;
        tx.dbcTime = ctx.dbc_time;
        tx.methodCount = ctx.method_count;
        tx.methodTime = ctx.method_time;
        if (ctx.error != null) {
            tx.error = ctx.error.txErrorCode;
            tx.errorLevel = ctx.error.level;
            if (TxTraceBackground.isBizException(ctx.error.className.hashCode())) {
                tx.errorLevel = (byte)10;
            }
            TxTraceBackground.errorMessageToTx(tx, ctx.error);
        } else if (ctx.exception != null && !TxTraceBackground.isIgnoreExceptionTx(ctx.exception, ctx.service_hash, ctx.service_name)) {
            ErrorArg arg = new ErrorArg();
            arg.exception = ctx.exception;
            arg.message = ctx.exception.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            tx.error = StatError.getInstance().addError(arg);
            if (TxTraceBackground.isBizException(ctx.exception) || TxTraceBackground.isBizExceptionAndStaus(ctx.exception, ctx.status)) {
                tx.errorLevel = (byte)10;
            } else {
                tx.errorLevel = (byte)20;
                ExceptionAlert.getInstance().service(ctx, arg);
            }
            TxTraceBackground.errorMessageToTx(tx, arg);
        } else if (ctx.unclosedConnMap != null && ctx.unclosedConnMap.size() > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.connection_not_close;
            arg.message = WHATAP_ERROR.connection_not_close.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            StackTraceElement[] stack = ctx.unclosedConnMap.entries().nextElement().getValue();
            tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
            tx.errorLevel = (byte)20;
            TxTraceBackground.errorMessageToTx(tx, arg);
        } else if (ctx.unclosedStmtMap != null && ctx.unclosedStmtMap.size() > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.stmt_not_close;
            arg.message = WHATAP_ERROR.stmt_not_close.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            StackTraceElement[] stack = ctx.unclosedStmtMap.entries().nextElement().getValue();
            tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
            tx.errorLevel = (byte)20;
            TxTraceBackground.errorMessageToTx(tx, arg);
        } else if (ctx.customLeak > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.custom_leak;
            arg.message = WHATAP_ERROR.custom_leak.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            tx.error = StatError.getInstance().addError(arg);
            tx.errorLevel = (byte)20;
            TxTraceBackground.errorMessageToTx(tx, arg);
        }
        tx.domain = ctx.http_host_hash;
        tx.referer = ctx.referer;
        tx.httpcCount = ctx.httpc_count;
        tx.httpcTime = ctx.httpc_time;
        if (ctx.remoteAddrIPv6) {
            ctx.setExtraField("RemoteIp6", new TextValue(ctx.remoteAddr));
        } else {
            tx.ipaddr = ctx.remoteIp;
        }
        tx.fields = ctx.fields;
        MeterServiceBackground.getInstance().add(tx);
        if (TxTraceBackground.conf.app_context_enabled) {
            AppCtxStatCollector.getInstance().endTx(ctx.appctx, tx);
            tx.appctx = ctx.appctx;
        }
        profile.oid = SecurityMaster.getInstance().OID;
        profile.transaction = tx;
        profile.time = tx.endTime;
        DataProfileAgent.sendProfile(ctx, profile, thr == REJECT);
        ctx.reset();
    }

    static void errorMessageToTx(TxRecord tx, ErrorArg error) {
        if (ConfTrace.txtext_error_enabled) {
            tx.error_class = error.className;
            if (error.message != null) {
                tx.error_message = error.message.length() > ConfTrace.txtext_error_length ? error.message.substring(0, ConfTrace.txtext_error_length) : error.message;
            }
        }
    }

    static boolean isBizException(Throwable ex) {
        return TxTraceBackground.conf._enable_biz_exceptions && TxTraceBackground.conf.biz_exceptions.contains(ex.getClass().getName().hashCode());
    }

    static boolean isBizExceptionAndStaus(Throwable ex, int status) {
        if (!TxTraceBackground.conf._enable_biz_exceptions_status || status == 0) {
            return false;
        }
        IntSet s = TxTraceBackground.conf.biz_exceptions_status.get(ex.getClass().getName().hashCode());
        if (s == null) {
            return false;
        }
        return s.contains(status);
    }

    static boolean isBizException(int errorClassHashCode) {
        return TxTraceBackground.conf._enable_biz_exceptions && TxTraceBackground.conf.biz_exceptions.contains(errorClassHashCode);
    }

    static boolean isIgnoreException(Throwable ex) {
        return TxTraceBackground.conf._enable_ignore_exceptions && TxTraceBackground.conf.ignore_exceptions.contains(ex.getClass().getName().hashCode());
    }

    static boolean isIgnoreExceptionTx(Throwable ex, int serviceHash, String serviceName) {
        if (ex == null) {
            return false;
        }
        if (TxTraceBackground.isIgnoreException(ex)) {
            return true;
        }
        if (!TxTraceBackground.conf._enable_ignore_exception_tx) {
            return false;
        }
        int exHash = ex.getClass().getName().hashCode();
        long key = BitUtil.composite(exHash, serviceHash);
        int val = TxTraceBackground.conf.ignoreExTxMap.get(key);
        switch (val) {
            case 1: {
                return true;
            }
            case -1: {
                return false;
            }
        }
        List<StrMatch> txPatterns = TxTraceBackground.conf.ignore_exception_tx_pattern.get(exHash);
        if (txPatterns == null || txPatterns.size() == 0) {
            TxTraceBackground.conf.ignoreExTxMap.put(key, -1);
            return false;
        }
        for (int i = 0; i < txPatterns.size(); ++i) {
            StrMatch m = txPatterns.get(i);
            if (!m.include(serviceName)) continue;
            TxTraceBackground.conf.ignoreExTxMap.put(key, 1);
            return true;
        }
        TxTraceBackground.conf.ignoreExTxMap.put(key, -1);
        return false;
    }
}

