/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.stat;

import whatap.agent.api.stat.KeyValue;
import whatap.agent.api.stat.Process;
import whatap.agent.api.stat.Record;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.StringKeyLinkedMap;
import whatap.util.ThreadUtil;

public class CustomCounter
extends Thread {
    private static CustomCounter instance;
    private StringKeyLinkedMap<Record> statTable = new StringKeyLinkedMap<Record>(){

        @Override
        protected Record create(String key) {
            return new Record();
        }
    }.setMax(100);
    private StringKeyLinkedMap<Process> procTable = new StringKeyLinkedMap().setMax(500);

    public static synchronized CustomCounter getInstance() {
        if (instance == null) {
            instance = new CustomCounter();
            instance.setDaemon(true);
            instance.setName("CustomCounter");
            instance.start();
        }
        return instance;
    }

    public void add(String category, String name, long value) {
        Record stat = this.statTable.intern(category);
        stat.longFields.add(name, value);
    }

    public void add(String category, String name, float value) {
        Record stat = this.statTable.intern(category);
        stat.floatFields.add(name, value);
    }

    public void put(String category, String name, long value) {
        Record stat = this.statTable.intern(category);
        stat.longFields.put(name, value);
    }

    public void put(String category, String name, float value) {
        Record stat = this.statTable.intern(category);
        stat.floatFields.put(name, value);
    }

    public void put(String category, String name, Value value) {
        Record stat = this.statTable.intern(category);
        stat.otherFields.put(name, value);
    }

    public Record getAndClear(String category) {
        return this.statTable.remove(category);
    }

    public Record get(String category) {
        return this.statTable.get(category);
    }

    public void add(String category, KeyValue ... fields) {
        Record stat = this.statTable.intern(category);
        for (KeyValue f : fields) {
            if (f.isFloat) {
                stat.floatFields.add(f.key, f.value.floatValue());
                continue;
            }
            stat.longFields.add(f.key, f.value.longValue());
        }
    }

    public void put(String category, KeyValue ... fields) {
        Record stat = this.statTable.intern(category);
        for (KeyValue f : fields) {
            if (f.isFloat) {
                stat.floatFields.put(f.key, f.value.floatValue());
                continue;
            }
            stat.longFields.put(f.key, f.value.longValue());
        }
    }

    public void registProcess(String category, final int interval, final MapValue tags, final boolean isAccumlative) {
        Process p = new Process(){

            protected TagCountPack run(String category) {
                Record stat;
                if (!this.isTimeDuration(interval)) {
                    return null;
                }
                this.lastProcessTime = System.currentTimeMillis();
                Record record = stat = isAccumlative ? CustomCounter.this.get(category) : CustomCounter.this.getAndClear(category);
                if (stat == null || stat.isEmpty()) {
                    return null;
                }
                TagCountPack p = new TagCountPack();
                if (tags != null) {
                    p.tags.putAll(tags);
                }
                stat.setTo(p.fields);
                return p;
            }
        };
        p.category = category;
        this.procTable.put(category, p);
    }

    public void registProcess(String category, Process p) {
        p.category = category;
        this.procTable.put(category, p);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    ThreadUtil.sleep(2000L);
                    if (this.procTable.size() == 0) continue;
                    en = this.procTable.values();
                    while (true) {
                        if (en.hasMoreElements()) ** break;
                        continue block3;
                        p = en.nextElement();
                        p.process();
                    }
                    break;
                }
            }
            catch (Throwable var1_2) {
                continue;
            }
            break;
        }
    }
}

