/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import whatap.agent.Configure;
import whatap.agent.Cypher;
import whatap.agent.Logger;
import whatap.agent.WsSysConf;
import whatap.agent.boot.JavaTypeEnum;
import whatap.agent.util.OidUtil;
import whatap.io.DataInputX;
import whatap.lang.License;
import whatap.lang.WsKey;
import whatap.lang.conf.ConfObserver;
import whatap.lang.slog.SLog;
import whatap.util.AnsiPrint;
import whatap.util.BitUtil;
import whatap.util.CastUtil;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.StringUtil;
import whatap.util.SysJMX;

public class SecurityMaster {
    public long PCODE;
    public int OID;
    public String ONAME;
    public int IP;
    public int MAC_HASH;
    public byte[] SECURE_KEY;
    public Cypher cypher;
    private static SecurityMaster instance = new SecurityMaster();
    public static boolean isWorkspace;
    String lastAccessKey = null;
    public int WSID = 0;
    public short SYS_ID = 0;
    public short PROD_ID = (short)101;
    private long lastOid = 0L;

    public static final SecurityMaster getInstance() {
        return instance;
    }

    public void init() {
        this.update();
        ConfObserver.add("SecurityMaster", new Runnable(){

            public void run() {
                SecurityMaster.this.update();
            }
        });
    }

    private void update() {
        Configure conf = Configure.getInstance();
        String thisAccessKey = conf.accessKey;
        if (StringUtil.isNotEmpty(thisAccessKey) && (this.cypher == null || !thisAccessKey.equals(this.lastAccessKey))) {
            this.lastAccessKey = thisAccessKey;
            this.update(thisAccessKey);
            return;
        }
    }

    public void update(String thisAccessKey) {
        try {
            this.resetLicense(thisAccessKey);
        }
        catch (Exception e) {
            Logger.println(AnsiPrint.red("WhaTap AccessKey Error :" + e.getMessage()));
        }
    }

    private void resetLicense(String lic) {
        License.Key key = License.getKey(lic);
        int wsid = BitUtil.getHigh(key.pcode);
        if (wsid > 0) {
            isWorkspace = true;
            short sysid = WsSysConf.read(this.PROD_ID);
            if (sysid > 0) {
                this.SYS_ID = sysid;
            }
            this.WSID = wsid;
            this.PCODE = BitUtil.composite(wsid, BitUtil.composite(this.PROD_ID, this.SYS_ID));
        } else {
            isWorkspace = false;
            this.PCODE = key.pcode;
        }
        Configure.PCODE = this.PCODE;
        Logger.green("PCODE=" + WsKey.toString(this.PCODE));
        this.SECURE_KEY = key.security_key;
        this.cypher = new Cypher(this.SECURE_KEY, 0);
    }

    public long resetWsid(short sysid) {
        if (sysid > 0) {
            WsSysConf.reset(this.PROD_ID, sysid);
        }
        this.SYS_ID = sysid;
        Configure.PCODE = this.PCODE = BitUtil.composite(this.WSID, BitUtil.composite(this.PROD_ID, this.SYS_ID));
        Logger.green("PCODE=" + WsKey.toString(this.PCODE));
        return this.PCODE;
    }

    public void decideAgentOnameOid(String myIp, int mac) {
        System.setProperty("whatap.ip", myIp);
        this.IP = myIp != null && myIp.indexOf(":") >= 0 ? HashUtil.hash(myIp) : DataInputX.toInt(IPUtil.toBytes(myIp), 0);
        this.MAC_HASH = mac;
        String oname = StringUtil.trim(System.getProperty("whatap.oname"));
        if (StringUtil.isNotEmpty(oname)) {
            this.OID = OidUtil.mkOid(oname);
            this.ONAME = oname;
            Configure.OID = this.OID;
            System.setProperty("whatap.oid", Integer.toString(this.OID));
            Logger.setProcName(oname);
            Logger.println(AnsiPrint.red("OID: " + this.OID + " ONAME: " + this.ONAME + " IP: " + IPUtil.toString(this.IP)) + " PID: " + SysJMX.getProcessPID());
            return;
        }
        Configure conf = Configure.getInstance();
        OidUtil ou = new OidUtil();
        ou.setIp(IPUtil.toString(this.IP));
        int service_port = CastUtil.cint(System.getProperty("whatap.port"));
        ou.setPort(service_port);
        ou.setPid(SysJMX.getProcessPID());
        System.setProperty("whatap.pid", Integer.toString(SysJMX.getProcessPID()));
        ou.setHostName(SysJMX.getHostName());
        ou.setType(JavaTypeEnum.getShortName(System.getProperty("whatap.type", "AP")));
        ou.setCmd(System.getProperty("sun.java.command"));
        ou.setAttr("okind", conf.OKIND_NAME);
        String defName = conf.WHATAP_MICRO_ENABLED ? conf.getValue("whatap.name.default", "{okind}-{ip2}-{ip3}") : (service_port > 0 ? conf.getValue("whatap.name.default", "{type}-{ip2}-{ip3}-{port}") : conf.getValue("whatap.name.default", "{type}-{ip2}-{ip3}-{pid}"));
        oname = ou.mkOname(conf.getValue("whatap.name", defName));
        this.OID = OidUtil.mkOid(oname);
        this.ONAME = oname;
        Configure.OID = this.OID;
        Logger.setProcName(oname);
        System.setProperty("whatap.oid", Integer.toString(this.OID));
        System.setProperty("whatap.oname", this.ONAME);
        if (this.lastOid != (long)this.OID) {
            this.lastOid = this.OID;
            Logger.println(SLog.n("oid", this.OID).a("oname", this.ONAME).a("ip", IPUtil.toString(this.IP)).a("pid", SysJMX.getProcessPID()).cyan());
        }
    }
}

