/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import whatap.util.FileUtil;
import whatap.util.SocketAddr;
import whatap.util.StringUtil;

public class PkgConfig {
    private static final String FILE_HOST_ID = "conf/host.id";
    private static final String FILE_COLLECTOR_CONF = "conf/collector.conf";
    private static String whatapPkgHome;
    private static Properties access;
    private static String host_id;

    public static String getHomeDir() {
        try {
            if (whatapPkgHome != null) {
                return whatapPkgHome;
            }
            String dir = System.getProperty("whatap.pkg.home");
            if (dir != null) {
                whatapPkgHome = dir;
                return dir;
            }
            dir = System.getenv("WHATAP_PKG_HOME");
            if (dir != null) {
                whatapPkgHome = dir;
                return dir;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        whatapPkgHome = "";
        return whatapPkgHome;
    }

    public static boolean isPkgAgent() {
        String pkg = PkgConfig.getHomeDir();
        return StringUtil.isNotEmpty(pkg);
    }

    public static String getAccessKey() {
        String v = PkgConfig.getEnv("WHATAP_ACCESSKEY", "whatap.accesskey");
        if (v != null) {
            return v;
        }
        PkgConfig.initAccess();
        return StringUtil.trim(access.getProperty("accesskey"));
    }

    private static String getEnv(String env, String prop) {
        String v = System.getenv(env);
        if (v != null) {
            return v;
        }
        return System.getProperty(prop);
    }

    private static String getServerAddr() {
        String v = PkgConfig.getEnv("WHATAP_SERVER_ADDRESS", "whatap.sever.address");
        if (v != null) {
            return v;
        }
        PkgConfig.initAccess();
        String addr = StringUtil.trim(access.getProperty("address"));
        if (addr != null) {
            return addr;
        }
        return StringUtil.trim(access.getProperty("addr"));
    }

    public static SocketAddr getServerSocketAddr(String defaultHost, int defaultPort) {
        String addr = PkgConfig.getServerAddr();
        if (addr == null) {
            return new SocketAddr(defaultHost, defaultPort);
        }
        try {
            int x = addr.indexOf(58);
            if (x < 0) {
                return new SocketAddr(addr, defaultPort);
            }
            return new SocketAddr(addr.substring(0, x), Integer.parseInt(addr.substring(x + 1)));
        }
        catch (Exception exception) {
            return new SocketAddr(defaultHost, defaultPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initAccess() {
        if (access == null) {
            String home = PkgConfig.getHomeDir();
            File file = new File(home, FILE_COLLECTOR_CONF);
            Properties p = new Properties();
            if (file.exists()) {
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(file));
                    p.load(in);
                }
                catch (Exception exception) {
                    FileUtil.close(in);
                    catch (Throwable throwable) {
                        FileUtil.close(in);
                        throw throwable;
                    }
                }
                FileUtil.close(in);
            }
            access = p;
        }
    }

    public static String getHostId() {
        if (StringUtil.isNotEmpty(host_id)) {
            return host_id;
        }
        if (!PkgConfig.isPkgAgent()) {
            return null;
        }
        try {
            String pkgHome = PkgConfig.getHomeDir();
            File hostIdFile = new File(pkgHome, FILE_HOST_ID);
            String uuid = "";
            if (!hostIdFile.exists() || hostIdFile.length() == 0L) {
                return null;
            }
            byte[] bytes = FileUtil.readAll(hostIdFile);
            if (bytes != null) {
                uuid = new String(bytes);
            }
            host_id = uuid;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host_id;
    }
}

