/*
 * Decompiled with CFR 0.152.
 */
package whatap;

import whatap.util.CastUtil;
import whatap.util.StringUtil;

public class ParsedVersion {
    public int major;
    public int minor;
    public String revision;
    public String build;

    public String toString() {
        return this.major + "." + this.minor + "_" + this.revision + " " + this.build;
    }

    public static ParsedVersion parse(String v) {
        try {
            ParsedVersion pv = new ParsedVersion();
            v = StringUtil.trimEmpty(v);
            int x = v.indexOf(32);
            if (x > 0) {
                ParsedVersion.setVersion(pv, v.substring(0, x).trim());
                pv.build = v.substring(x + 1).trim();
            } else {
                ParsedVersion.setVersion(pv, v);
            }
            return pv;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setVersion(ParsedVersion pv, String v1) {
        String[] tokens = StringUtil.tokenizer(v1, "._");
        pv.major = ParsedVersion.toInt(tokens, 0);
        pv.minor = ParsedVersion.toInt(tokens, 1);
        pv.revision = tokens[2];
    }

    private static int toInt(String[] tokens, int i) {
        if (i < tokens.length) {
            return CastUtil.cint(tokens[i]);
        }
        return 0;
    }
}

