/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1.work;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.ThreadUtil;
import whatap.v1.ITask;
import whatap.v1.WhatapConf;
import whatap.v1.work.TaskWrap;

public class TaskExecutorThread
extends Thread {
    private static TaskExecutorThread instance;
    public boolean debug_api_task = false;
    protected StringKeyLinkedMap<TaskWrap> taskMap = new StringKeyLinkedMap().setMax(100);
    private Executor threadPool;

    public static final synchronized TaskExecutorThread getInstance() {
        if (instance == null) {
            instance = new TaskExecutorThread();
            instance.setName("TaskExecutorThread");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    TaskExecutorThread() {
        this.debug_api_task = Configure.getInstance().getBoolean("debug_api_task", false);
        WhatapConf.onModified(TaskExecutorThread.class.getName(), new Runnable(){

            public void run() {
                TaskExecutorThread.this.debug_api_task = Configure.getInstance().getBoolean("debug_api_task", false);
            }
        });
    }

    public void run() {
        while (true) {
            ThreadUtil.sleep(1000L);
            try {
                if (this.taskMap.size() == 0) {
                    ThreadUtil.sleep(5000L);
                    continue;
                }
                this.process();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void regist(String name, long interval, boolean exactTime, ITask handler) {
        if (handler == null) {
            Logger.println("API-TASK", "fail to regist the task,it is null");
            return;
        }
        TaskWrap task = new TaskWrap();
        task.category = name;
        task._interval_ = Math.max(interval, 2000L);
        task.exactTime = exactTime;
        task.handler = handler;
        this.taskMap.put(name, task);
    }

    public void resetThreadPool(int size) {
        if (this.threadPool == null) {
            this.threadPool = Executors.newFixedThreadPool(size);
        }
    }

    private void process() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newFixedThreadPool(2);
        }
        StringEnumer en = this.taskMap.keys();
        while (en.hasMoreElements()) {
            String taskId = en.nextString();
            TaskWrap task = this.taskMap.get(taskId);
            if (task == null || task.running) continue;
            long now = System.currentTimeMillis();
            if (task._start_time_ == 0L) {
                task._start_time_ = task.exactTime ? now / task._interval_ * task._interval_ : now / 1000L * 1000L;
                task._next_time_ = task._start_time_ + task._interval_;
                continue;
            }
            if (now < task._next_time_) continue;
            long delta = now - task._start_time_;
            task._next_time_ = task._start_time_ + (1L + delta / task._interval_) * task._interval_;
            task.debug_enabled = this.debug_api_task;
            this.threadPool.execute(task);
        }
    }
}

