/*
 * Decompiled with CFR 0.152.
 */
package whatap.util.expr;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import whatap.util.Stack;
import whatap.util.StringUtil;
import whatap.util.expr.YyLex;
import whatap.util.expr.YyToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprParser {
    public Stack<YyToken> parse(String rule) throws RuntimeException {
        List<YyToken> tmp = this.step1(rule);
        return this.step2(tmp);
    }

    public List<Stack<YyToken>> parseSelect(String rule) throws RuntimeException {
        List<YyToken> tmp = this.step1(rule);
        return this.stepArray(tmp);
    }

    private List<YyToken> step1(String rule) throws RuntimeException {
        Stack<YyToken> stack = new Stack<YyToken>();
        try {
            YyToken t;
            YyLex yyLex = new YyLex(new StringReader(rule));
            YyToken lastToken = new YyToken(0, "");
            ArrayList<YyToken> list = new ArrayList<YyToken>();
            while ((t = yyLex.yylex()) != null) {
                if (t.index == 11 && (lastToken.index <= 51 || lastToken.index > 1000)) {
                    t = yyLex.yylex();
                    t.mux = -1;
                    list.add(t);
                    lastToken = t;
                    continue;
                }
                list.add(t);
                if (t.index == 91) {
                    t.value = StringUtil.strip((String)t.value, " (");
                    t = new YyToken(1001, "[");
                    list.add(t);
                    stack.push(t);
                } else if (t.index == 50) {
                    if (lastToken.index == 120) {
                        lastToken.index = 91;
                        t.index = 1001;
                        t.value = "[";
                    }
                    stack.push(t);
                } else if (t.index == 51) {
                    YyToken tmp = (YyToken)stack.pop();
                    if (tmp.index == 1001) {
                        t.index = 1002;
                        t.value = "]";
                    }
                }
                lastToken = t;
            }
            return list;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("unknown rule error");
        }
        catch (Exception e) {
            throw new RuntimeException("unknown rule error");
        }
    }

    private Stack<YyToken> step2(List<YyToken> yyTokens) throws RuntimeException {
        Stack<YyToken> result = new Stack<YyToken>();
        Stack<YyToken> stack = new Stack<YyToken>();
        YyToken temp = null;
        int currentProcedence = 0;
        int stackProcedence = 0;
        block0: for (int i = yyTokens.size() - 1; i >= 0; --i) {
            YyToken yyToken = yyTokens.get(i);
            if (yyToken.index == 1001) {
                while (true) {
                    temp = (YyToken)stack.pop();
                    if (temp.index >= 1000) break;
                    result.push(temp);
                }
                result.push(yyToken);
                result.push(yyTokens.get(i - 1));
                --i;
                continue;
            }
            if (yyToken.index == 1002) {
                result.push(yyToken);
                stack.push(yyToken);
                continue;
            }
            if (yyToken.index == 51) {
                stack.push(yyToken);
                continue;
            }
            if (yyToken.index == 50) {
                while (true) {
                    temp = (YyToken)stack.pop();
                    if (temp.index == 51) continue block0;
                    result.push(temp);
                }
            }
            if (yyToken.index == 1003) {
                while (true) {
                    temp = (YyToken)stack.pop();
                    if (temp.index >= 1000) break;
                    result.push(temp);
                }
                result.push(yyToken);
                stack.push(yyToken);
                continue;
            }
            if (yyToken.index > 100) {
                result.push(yyToken);
                continue;
            }
            if (stack.empty()) {
                stack.push(yyToken);
                continue;
            }
            currentProcedence = this.precedence(yyToken);
            do {
                if (currentProcedence < (stackProcedence = this.precedence(temp = (YyToken)stack.pop()))) {
                    result.push(temp);
                    if (!stack.empty()) continue;
                    stack.push(yyToken);
                    continue block0;
                }
                stack.push(temp);
                stack.push(yyToken);
            } while (currentProcedence < stackProcedence);
        }
        while (!stack.empty()) {
            YyToken tok = (YyToken)stack.pop();
            if (tok.index == 50 || tok.index == 51) {
                throw new RuntimeException("Unknown rule error");
            }
            result.push(tok);
        }
        return result;
    }

    private List<Stack<YyToken>> stepArray(List<YyToken> yyTokens) throws RuntimeException {
        ArrayList<Stack<YyToken>> out = new ArrayList<Stack<YyToken>>();
        Stack<YyToken> result = this.createItem();
        Stack<YyToken> stack = new Stack<YyToken>();
        YyToken temp = null;
        int currentProcedence = 0;
        int stackProcedence = 0;
        int bracket_open = 0;
        block0: for (int i = yyTokens.size() - 1; i >= 0; --i) {
            YyToken yyToken = yyTokens.get(i);
            if (yyToken.index == 1001) {
                ++bracket_open;
                while (stack.size() > 0) {
                    temp = (YyToken)stack.pop();
                    if (temp.index >= 1000) break;
                    result.push(temp);
                }
                result.push(yyToken);
                result.push(yyTokens.get(i - 1));
                --i;
                continue;
            }
            if (yyToken.index == 1002) {
                --bracket_open;
                result.push(yyToken);
                stack.push(yyToken);
                continue;
            }
            if (yyToken.index == 51) {
                stack.push(yyToken);
                continue;
            }
            if (yyToken.index == 50) {
                while (true) {
                    temp = (YyToken)stack.pop();
                    if (temp.index == 51) continue block0;
                    result.push(temp);
                }
            }
            if (yyToken.index == 1003) {
                if (stack.size() == 0) {
                    out.add(result);
                    result = this.createItem();
                    continue;
                }
                while (stack.size() > 0) {
                    temp = (YyToken)stack.pop();
                    if (temp.index >= 1000) break;
                    result.push(temp);
                }
                if (bracket_open == 0) {
                    out.add(result);
                    result = this.createItem();
                    continue;
                }
                result.push(yyToken);
                stack.push(yyToken);
                continue;
            }
            if (yyToken.index > 100) {
                result.push(yyToken);
                continue;
            }
            if (stack.empty()) {
                stack.push(yyToken);
                continue;
            }
            currentProcedence = this.precedence(yyToken);
            do {
                if (currentProcedence <= (stackProcedence = this.precedence(temp = (YyToken)stack.pop()))) {
                    result.push(temp);
                    if (!stack.empty()) continue;
                    stack.push(yyToken);
                    continue block0;
                }
                stack.push(temp);
                stack.push(yyToken);
            } while (currentProcedence <= stackProcedence);
        }
        while (!stack.empty()) {
            YyToken tok = (YyToken)stack.pop();
            if (tok.index == 50 || tok.index == 51) {
                throw new RuntimeException("Unknown rule error");
            }
            result.push(tok);
        }
        if (result.size() > 0) {
            out.add(result);
        }
        ArrayList<Stack<YyToken>> out2 = new ArrayList<Stack<YyToken>>();
        for (int i = out.size() - 1; i >= 0; --i) {
            Stack item = (Stack)out.get(i);
            out2.add(item);
        }
        return out2;
    }

    protected Stack<YyToken> createItem() {
        return new Stack<YyToken>(1, 3);
    }

    private int precedence(YyToken yyToken) {
        if (yyToken.index < 100) {
            return 10 - yyToken.index / 10;
        }
        if (yyToken.index > 1000) {
            return 2;
        }
        return 0;
    }
}

