/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.TextValue;
import whatap.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtil {
    public static void sleep(long tm) {
        try {
            Thread.sleep(tm);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void qWait() {
        ThreadUtil.sleep(1L);
    }

    public static void wait(Object o) {
        try {
            o.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void wait(Object o, long time) {
        try {
            o.wait(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getName(Thread t) {
        return ThreadUtil.getName(t.getClass());
    }

    public static String getName(Class clazz) {
        String name = clazz.getName();
        if (!name.startsWith("whatap.agent.")) {
            return name;
        }
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static MapValue getThreadDetail(long thread_id) {
        MapValue m = new MapValue();
        if (thread_id == 0L) {
            return m;
        }
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        ThreadInfo f = tmb.getThreadInfo(thread_id, 500);
        if (f == null) {
            return m;
        }
        m.put("Thread Id", new DecimalValue(f.getThreadId()));
        m.put("Thread Cpu Time", new DecimalValue(tmb.getThreadCpuTime(thread_id) / 1000000L));
        m.put("Thread User Time", new DecimalValue(tmb.getThreadUserTime(thread_id) / 1000000L));
        m.put("Blocked Count", new DecimalValue(f.getBlockedCount()));
        m.put("Blocked Time", new DecimalValue(f.getBlockedTime()));
        m.put("Waited Count", new DecimalValue(f.getWaitedCount()));
        m.put("Waited Time", new DecimalValue(f.getWaitedTime()));
        m.put("Lock Owner Id", new DecimalValue(f.getLockOwnerId()));
        m.put("Lock Name", new TextValue(f.getLockName()));
        m.put("Lock Owner Name", new TextValue(f.getLockOwnerName()));
        m.put("Thread Name", new TextValue(f.getThreadName()));
        m.put("Stack Trace", new TextValue(ThreadUtil.getStackTrace(f.getStackTrace()).toString()));
        m.put("State", new TextValue(f.getThreadState().toString()));
        return m;
    }

    public static String getThreadStack(long id) {
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        ThreadInfo f = tmb.getThreadInfo(id, 500);
        if (f == null) {
            return null;
        }
        return ThreadUtil.getStackTrace(f.getStackTrace());
    }

    public static String getThreadStack(long id, int maxdepth) {
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        ThreadInfo f = tmb.getThreadInfo(id, maxdepth);
        if (f == null) {
            return null;
        }
        return ThreadUtil.getStackTrace(f.getStackTrace());
    }

    public static String getThreadStack() {
        return ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace());
    }

    public static String getStackTrace(StackTraceElement[] se) {
        return ThreadUtil.getStackTrace(se, 0);
    }

    public static String getStackTrace(StackTraceElement[] se, int skip) {
        if (se == null || se.length <= skip) {
            return "";
        }
        String CRLF = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (int i = skip; i < se.length; ++i) {
            if (sb.length() > 0) {
                sb.append(CRLF);
            }
            sb.append(se[i]);
        }
        return sb.toString();
    }

    public static String getStackTrace(StackTraceElement[] se, int skip, String CRLF) {
        if (se == null || se.length <= skip) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = skip; i < se.length; ++i) {
            if (sb.length() > 0) {
                sb.append(CRLF);
            }
            sb.append(se[i]);
        }
        return sb.toString();
    }

    public static String getDumpStack(StackTraceElement[] se) {
        String CRLF = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < se.length; ++i) {
            if (sb.length() > 0) {
                sb.append(CRLF);
            }
            sb.append("\t" + se[i]);
        }
        return sb.toString();
    }

    private static void getDumpStack(List<String> buff, StackTraceElement[] se) {
        for (int i = 0; i < se.length; ++i) {
            buff.add("\t" + se[i]);
        }
    }

    public static MapValue getThreadList() {
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        long[] thread = tmb.getAllThreadIds();
        MapValue pack = new MapValue();
        ListValue id = pack.newList("id");
        ListValue name = pack.newList("name");
        ListValue stat = pack.newList("stat");
        ListValue cpu = pack.newList("cpu");
        for (int i = 0; i < thread.length; ++i) {
            try {
                ThreadInfo fo = tmb.getThreadInfo(thread[i]);
                if (fo == null) continue;
                long _id = fo.getThreadId();
                String _name = fo.getThreadName();
                String _stat = fo.getThreadState().toString();
                long _cpu = tmb.getThreadCpuTime(thread[i]) / 1000000L;
                id.add(_id);
                name.add(_name);
                stat.add(_stat);
                cpu.add(_cpu);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pack;
    }

    public static ThreadPoolExecutor createExecutor(final String name, int count, int keepAlive, final boolean isDaemon) {
        ThreadPoolExecutor exe = new ThreadPoolExecutor(count, count, (long)keepAlive, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private int threadNum = 1;

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name + this.threadNum++);
                t.setDaemon(isDaemon);
                return t;
            }
        });
        return exe;
    }

    public static String getStackTrace(Throwable t) {
        String CRLF = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(t.toString() + CRLF);
        StackTraceElement[] se = t.getStackTrace();
        if (se != null) {
            for (int i = 0; i < se.length; ++i) {
                if (se[i] == null) continue;
                sb.append("\t" + se[i].toString());
                if (i == se.length - 1) continue;
                sb.append(CRLF);
            }
        }
        return sb.toString();
    }

    public static void getStackTrace(StringBuffer sb, Throwable t, int max) {
        if (t == null) {
            return;
        }
        if (max <= 0) {
            max = 10000;
        }
        String CRLF = System.getProperty("line.separator");
        sb.append(t);
        StackTraceElement[] se = t.getStackTrace();
        if (se != null && se.length > 0) {
            for (int i = 0; i < se.length && i < max; ++i) {
                sb.append(CRLF);
                sb.append("\t" + se[i]);
            }
            if (max < se.length) {
                sb.append(CRLF + "\t...more lines " + (se.length - max));
            }
        } else {
            sb.append(CRLF + "\tno stack info ");
        }
    }

    public static void main(String[] args) {
        System.out.println(Long.toHexString(100L));
    }

    public static String getThreadDump() {
        StringBuffer dump = new StringBuffer(2048);
        dump.append(DateUtil.format(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss")).append("\n");
        dump.append("WhaTap thread dump " + System.getProperty("java.vm.name")).append("\n");
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        long[] thread = tmb.getAllThreadIds();
        for (int i = 0; i < thread.length; ++i) {
            ThreadInfo f = tmb.getThreadInfo(thread[i], 500);
            if (f == null) continue;
            dump.append("\n");
            StackTraceElement[] se = f.getStackTrace();
            if (se != null && se.length > 0) {
                dump.append(ThreadUtil.getThreadHead(f)).append("\n");
                dump.append("   java.lang.Thread.State: ").append((Object)f.getThreadState()).append("\n");
                dump.append(ThreadUtil.getDumpStack(se)).append("\n");
                continue;
            }
            dump.append(ThreadUtil.getThreadHead(f)).append(" ").append(f.getThreadState().toString().toLowerCase()).append("\n");
        }
        return dump.toString();
    }

    public static String getThreadHead(ThreadInfo f) {
        StringBuffer sb = new StringBuffer();
        sb.append('\"').append(f.getThreadName()).append('\"');
        sb.append(" tid=" + f.getThreadId());
        sb.append(" native=" + f.isInNative());
        sb.append(" suspended=" + f.isSuspended());
        return sb.toString();
    }

    public static List<String> getThreadDumpList() {
        ArrayList<String> dump = new ArrayList<String>();
        dump.add(DateUtil.format(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
        dump.add("WhaTap thread dump " + System.getProperty("java.vm.name"));
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        long[] thread = tmb.getAllThreadIds();
        for (int i = 0; i < thread.length; ++i) {
            dump.add("");
            ThreadInfo f = tmb.getThreadInfo(thread[i], 500);
            StackTraceElement[] se = f.getStackTrace();
            if (se.length > 0) {
                dump.add(ThreadUtil.getThreadHead(f));
                dump.add("   java.lang.Thread.State: " + (Object)((Object)f.getThreadState()));
                ThreadUtil.getDumpStack(dump, se);
                continue;
            }
            dump.add(ThreadUtil.getThreadHead(f) + " " + f.getThreadState().toString().toLowerCase());
        }
        return dump;
    }
}

