/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.util.CompareUtil;
import whatap.util.FloatEnumer;
import whatap.util.StringEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFloatMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringFloatEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private float NONE = 0.0f;

    public StringFloatMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringFloatEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringFloatMap setNullValue(float none) {
        this.NONE = none;
        return this;
    }

    public StringFloatMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(1);
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized FloatEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<StringFloatEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(float value) {
        StringFloatEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringFloatEntry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        StringFloatEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringFloatEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized float get(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringFloatEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringFloatEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringFloatEntry[] newMap = new StringFloatEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringFloatEntry old = oldMap[i];
            while (old != null) {
                StringFloatEntry e = old;
                old = old.next;
                int index = (e.key.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized float put(String key, float value) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringFloatEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new StringFloatEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized float add(String key, float value) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringFloatEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value += value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new StringFloatEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized float intern(String key, float def) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringFloatEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new StringFloatEntry(key, def, tab[index]);
        ++this.count;
        return def;
    }

    public synchronized float remove(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringFloatEntry e = tab[index];
        StringFloatEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                float oldValue = e.value;
                e.value = this.NONE;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized void clear() {
        StringFloatEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringFloatEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringFloatEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringFloatEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringFloatEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public synchronized void sort(Comparator<StringFloatEntry> c) {
        ArrayList<StringFloatEntry> list = new ArrayList<StringFloatEntry>(this.size());
        Enumeration<StringFloatEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            StringFloatEntry e = (StringFloatEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    FloatEnumer {
        StringFloatEntry[] table;
        int index;
        StringFloatEntry entry;
        StringFloatEntry lastReturned;
        byte type;

        Enumer(byte type) {
            this.table = StringFloatMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringFloatEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return Float.valueOf(e.value);
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public float nextFloat() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringFloatEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case 2: {
                        return e.value;
                    }
                }
                return StringFloatMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }

        public String nextString() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringFloatEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                }
                return null;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    public static class StringFloatEntry {
        String key;
        float value;
        StringFloatEntry next;

        protected StringFloatEntry(String key, float value, StringFloatEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringFloatEntry(this.key, this.value, this.next == null ? null : (StringFloatEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringFloatEntry)) {
                return false;
            }
            StringFloatEntry e = (StringFloatEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ (int)this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

