/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import whatap.util.FileUtil;
import whatap.util.ThreadUtil;

public class RunExec {
    private String cmd;
    private String[] env;
    private File dir;
    private Throwable exception;
    private Process process;
    private StringBuilder error = new StringBuilder();
    private StringBuilder output = new StringBuilder();
    long timeout = 5000L;

    public RunExec(String cmd) {
        this.cmd = cmd;
    }

    public RunExec setEnv(String[] env) {
        this.env = env;
        return this;
    }

    public RunExec setWorkDir(File dir) {
        this.dir = dir;
        return this;
    }

    public int exec() {
        try {
            this.process = Runtime.getRuntime().exec(this.cmd, this.env, this.dir);
            this.output = new StringBuilder();
            Thread t1 = this.readAndClose("RunExec-Output", this.process.getInputStream(), this.output);
            this.error = new StringBuilder();
            Thread t2 = this.readAndClose("RunExec-Error", this.process.getErrorStream(), this.error);
            this.process.getOutputStream().close();
            if (this.timeout > 0L) {
                int i = 0;
                while ((t1.isAlive() || t2.isAlive()) && (long)i < this.timeout) {
                    ThreadUtil.sleep(50L);
                    i += 50;
                }
                if (t1.isAlive() || t2.isAlive()) {
                    this.process.destroy();
                    this.setException(new Exception("TimeOutException"));
                    return 9;
                }
            } else {
                this.process.waitFor();
            }
            return this.process.exitValue();
        }
        catch (Throwable e) {
            this.setException(e);
            return -1;
        }
    }

    private void setException(Throwable e) {
        if (this.exception == null) {
            this.exception = e;
        }
    }

    private Thread readAndClose(String name, final InputStream fin, final StringBuilder sb) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buff = new byte[1024];
                    int n = fin.read(buff);
                    for (int k = 0; n >= 0 && k < 0x100000; ++k) {
                        if (out.size() < 0x100000) {
                            out.write(buff, 0, n);
                        }
                        n = fin.read(buff);
                    }
                    sb.append(new String(out.toByteArray()));
                }
                catch (Throwable t) {
                    RunExec.this.setException(t);
                }
                finally {
                    FileUtil.close(fin);
                }
            }
        });
        t.setDaemon(true);
        t.setName(name);
        t.start();
        return t;
    }

    public String getError() {
        return this.error.toString();
    }

    public String getOutput() {
        return this.output.toString();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setTimeout(long time) {
        this.timeout = time;
    }
}

