/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import whatap.util.DateTimeHelper;
import whatap.util.StringKeyLinkedMap;

public class DateUtil {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_FIVE_MINUTE = 300000L;
    public static final long MILLIS_PER_TEN_MINUTE = 600000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SECONDS_PER_DAY = 86400;
    public static final DateTimeHelper helper = DateTimeHelper.getDateTimeHelper();
    public static final float MICROS_PER_SECOND = 1000000.0f;
    private static StringKeyLinkedMap<SimpleDateFormat> parsers = new StringKeyLinkedMap<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat create(String pattern) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdf;
        }
    }.setMax(100);
    private static long delta;

    public static String datetime(long time) {
        return helper.datetime(time);
    }

    public static String timestamp(long time) {
        return helper.timestamp(time);
    }

    public static String yyyymmdd(long time) {
        return helper.yyyymmdd(time);
    }

    public static String weekday(long time) {
        return helper.weekday(time);
    }

    public static long getDateUnit() {
        return helper.getDateUnit();
    }

    public static long getDateUnit(long time) {
        return helper.getDateUnit(time);
    }

    public static String ymdhms(long time) {
        return helper.yyyymmdd(time) + helper.hhmmss(time);
    }

    public static String hhmmss(long time) {
        return helper.hhmmss(time);
    }

    public static String hhmm(long now) {
        return helper.hhmm(now);
    }

    public static String yyyymmdd() {
        return helper.yyyymmdd(DateUtil.currentTime());
    }

    public static String getLogTime() {
        return helper.logtime(DateUtil.currentTime());
    }

    public static String getLogTime(long time) {
        return helper.logtime(time);
    }

    public static long yyyymmdd(String date) {
        return helper.yyyymmdd(date);
    }

    public static long hhmm(String date) {
        return helper.hhmm(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTime(String date, String format) {
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(date);
        }
        try {
            SimpleDateFormat sdf;
            SimpleDateFormat simpleDateFormat = sdf = parsers.intern(format);
            synchronized (simpleDateFormat) {
                return sdf.parse(date).getTime();
            }
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long stime, String format) {
        SimpleDateFormat sdf;
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(stime);
        }
        SimpleDateFormat simpleDateFormat = sdf = parsers.intern(format);
        synchronized (simpleDateFormat) {
            return sdf.format(new Date(stime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long stime, String format, Locale locale) {
        SimpleDateFormat sdf;
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(stime);
        }
        SimpleDateFormat simpleDateFormat = sdf = parsers.intern(format + locale.getCountry());
        synchronized (simpleDateFormat) {
            return sdf.format(new Date(stime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parse(String date, String format) {
        SimpleDateFormat sdf;
        if (format.equals("yyyyMMdd")) {
            return helper.yyyymmdd(date);
        }
        SimpleDateFormat simpleDateFormat = sdf = parsers.intern(format);
        synchronized (simpleDateFormat) {
            try {
                return sdf.parse(date).getTime();
            }
            catch (ParseException e) {
                return helper.getBaseTime();
            }
        }
    }

    public static boolean isSameDay(Date date, Date date2) {
        return helper.getDateUnit(date.getTime()) == helper.getDateUnit(date2.getTime());
    }

    public static boolean isToday(long time) {
        return helper.getDateUnit(time) == helper.getDateUnit(DateUtil.currentTime());
    }

    public static int getHour(Date date) {
        return helper.getHour(date.getTime());
    }

    public static int getMin(Date date) {
        return helper.getMM(date.getTime());
    }

    public static int getHour(long time) {
        return helper.getHour(time);
    }

    public static int getMin(long time) {
        return helper.getMM(time);
    }

    public static String timestamp() {
        return helper.timestamp(DateUtil.currentTime());
    }

    public static String timestampFileName() {
        return helper.timestampFileName(DateUtil.currentTime());
    }

    public static int getDateMillis(long time) {
        return helper.getDateMillis(time);
    }

    public static long getDateStartTime(long time) {
        return helper.getDateStartTime(time);
    }

    public static long getTimeUnit(long time) {
        return helper.getTimeUnit(time);
    }

    public static long getHourUnit(long time) {
        return helper.getHourUnit(time);
    }

    public static long getTenMinUnit(long time) {
        return helper.getTenMinUnit(time);
    }

    public static long getFiveMinUnit(long time) {
        return helper.getFiveMinUnit(time);
    }

    public static long getMinUnit(long time) {
        return helper.getMinUnit(time);
    }

    public static long reverseHourUnit(long unit) {
        return helper.reverseHourUnit(unit);
    }

    public static long reverseUnit(long unit, long millis) {
        return helper.reverseUnit(unit, millis);
    }

    public static long now() {
        return DateUtil.currentTime();
    }

    public static long systime() {
        return System.currentTimeMillis();
    }

    public static long getYear(long time, int delta) {
        return helper.getYear(time, delta);
    }

    public static long getMonth(long time, int delta) {
        return helper.getMonth(time, delta);
    }

    public static long getDate(long time, int delta) {
        return helper.getDate(time, delta);
    }

    public static String uptime(long time) {
        return helper.uptime(time);
    }

    public static long epochtime(int year, int month, int day, int hour, int minute, int second) {
        return helper.epochtime(year, month, day, hour, minute, second);
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(new Date());
        long time = DateUtil.currentTime();
        String s = DateUtil.timestamp(time);
        System.out.println(s);
        long t2 = DateUtil.getTime(s, "yyyyMMdd HH:mm:ss.SSS");
        System.out.println("t1=" + time);
        System.out.println("t2=" + t2);
    }

    public static long currentTime() {
        return System.currentTimeMillis() + delta;
    }

    public static long setServerTime(long time, double syncfactor) {
        long now = System.currentTimeMillis();
        delta = time - now;
        if (delta != 0L) {
            delta = (long)((double)delta * syncfactor);
        }
        return delta;
    }

    public static long getServerDelta() {
        return delta;
    }

    public static long sinceMillis(long lastLogDebugPrint) {
        return DateUtil.now() - lastLogDebugPrint;
    }

    public static long nanoToMillis() {
        return System.nanoTime() / 1000000L;
    }
}

