/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.Base64;

public class CypherUtil {
    public static String md5(String plainText) {
        String md5Text = null;
        if (plainText != null) {
            try {
                byte[] byteArray = plainText.getBytes();
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(byteArray);
                byte[] md5Bytes = md5.digest();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < md5Bytes.length; ++i) {
                    if ((md5Bytes[i] & 0xFF) < 16) {
                        buf.append("0");
                    }
                    buf.append(Long.toString(md5Bytes[i] & 0xFF, 16));
                }
                md5Text = buf.toString();
            }
            catch (Throwable t) {
                return plainText;
            }
        }
        return md5Text;
    }

    private static Key genKey() throws GeneralSecurityException {
        String nm = CypherUtil.class.getSimpleName();
        byte[] host = (nm + "012345678").getBytes();
        byte[] key = new byte[8];
        System.arraycopy(host, 0, key, 0, 8);
        return SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key));
    }

    public static String decrypt(String encoded) {
        try {
            Key key = CypherUtil.genKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(2, key);
            byte[] cyper = Base64.decode(encoded);
            byte[] decoded = cipher.doFinal(cyper);
            return new DataInputX(decoded).readText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String plain) {
        try {
            Key key = CypherUtil.genKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] plainBytes = CypherUtil.padding(new DataOutputX().writeText(plain).toByteArray());
            byte[] encoded = cipher.doFinal(plainBytes);
            return Base64.encode(encoded);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] padding(byte[] src) {
        int destlen = (src.length / 8 + 1) * 8;
        byte[] dest = new byte[destlen];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static void main(String[] args) {
        String pwd = "admin";
        String md5 = CypherUtil.md5(pwd);
        String cnd = CypherUtil.encrypt(pwd);
        String rtn = CypherUtil.decrypt(cnd);
        System.out.println("'" + pwd + "'");
        System.out.println("'" + md5 + "'");
        System.out.println("'" + cnd + "'");
        System.out.println("'" + rtn + "'");
    }
}

